/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.turret;

import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.client.turret.ITurretRenderRegistry;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretRender;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.model.ModelTurretBase;
import de.sanandrew.mods.turretmod.client.model.ModelTurretFlamethrower;
import de.sanandrew.mods.turretmod.client.model.ModelTurretLaser;
import de.sanandrew.mods.turretmod.client.model.ModelTurretMinigun;
import de.sanandrew.mods.turretmod.client.model.ModelTurretRevolver;
import de.sanandrew.mods.turretmod.client.model.ModelTurretShotgun;
import de.sanandrew.mods.turretmod.client.render.layer.LayerTurretGlow;
import de.sanandrew.mods.turretmod.client.render.layer.LayerTurretUpgrades;
import de.sanandrew.mods.turretmod.client.render.turret.TurretRenderBase;
import de.sanandrew.mods.turretmod.client.render.turret.TurretRenderShieldGen;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class RenderTurret<E extends EntityLiving>
extends RenderLiving<E>
implements ITurretRenderRegistry<E> {
    private final Map<ITurret, ITurretRender<?, E>> turretRenders = new HashMap();
    private final Map<ITurret, List<LayerRenderer<E>>> turretLayers = new HashMap<ITurret, List<LayerRenderer<E>>>();

    public RenderTurret(RenderManager manager) {
        super(manager, new ModelBase(){}, 0.5f);
        TurretModRebirth.PLUGINS.forEach(plugin -> plugin.registerTurretRenderer(this));
    }

    @Override
    public <T extends ModelBase> boolean registerRender(@Nonnull ITurret turret, @Nonnull ITurretRender<T, E> render) {
        if (this.turretRenders.containsKey(turret)) {
            TmrConstants.LOG.log(Level.WARN, String.format("Cannot register renderer for turret %s since it already has one.", turret.getName()));
            return false;
        }
        this.turretRenders.put(turret, render);
        List layers = this.turretLayers.compute(turret, (key, val) -> new ArrayList());
        render.addLayers(layers);
        return true;
    }

    @Override
    public ITurretRender<?, E> removeRender(ITurret turret) {
        ITurretRender<?, E> oldRender = this.turretRenders.remove(turret);
        this.turretLayers.remove(turret);
        return oldRender;
    }

    @Override
    public void addUpgradeLayer(List<LayerRenderer<E>> layerList) {
        layerList.add(new LayerTurretUpgrades());
    }

    @Override
    public <T extends ModelBase> void addGlowLayer(List<LayerRenderer<E>> layerList, ITurretRender<T, E> render) {
        layerList.add(new LayerTurretGlow(this, (ModelBase)render.getNewModel(0.001f)));
    }

    public void func_76986_a(E entity, double x, double y, double z, float entityYaw, float partialTicks) {
        ITurret turret = ((ITurretInst)entity).getTurret();
        ITurretRender<?, E> render = this.turretRenders.get(turret);
        if (render != null) {
            this.field_77045_g = render.getModel();
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
            render.doRender((ITurretInst)entity, x, y, z, entityYaw, partialTicks);
            RenderTurret.renderTurretRange((ITurretInst)entity, x, y, z);
        }
    }

    protected void renderLayers(E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        if (this.turretLayers.containsKey(((ITurretInst)entity).getTurret())) {
            this.turretLayers.get(((ITurretInst)entity).getTurret()).forEach(layer -> {
                boolean hasBrightnessSet = this.func_177092_a((EntityLivingBase)entity, partialTicks, layer.func_177142_b());
                layer.func_177141_a((EntityLivingBase)entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn);
                if (hasBrightnessSet) {
                    this.func_177091_f();
                }
            });
        }
    }

    protected void applyRotations(E turret, float x, float y, float z) {
        super.func_77043_a(turret, x, y, z);
        if (((ITurretInst)turret).isUpsideDown()) {
            GlStateManager.func_179109_b((float)0.0f, (float)(((EntityLiving)turret).field_70131_O + 0.2f), (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(E entity) {
        return ((ITurretInst)entity).getTurret().getStandardTexture((ITurretInst)entity);
    }

    protected boolean func_177070_b(E entity) {
        return false;
    }

    private static void renderTurretRange(ITurretInst turret, double x, double y, double z) {
        if (turret.showRange()) {
            double cz;
            double cy;
            double cx;
            GlStateManager.func_179090_x();
            float prevBrightX = OpenGlHelper.lastBrightnessX;
            float prevBrightY = OpenGlHelper.lastBrightnessY;
            int brightness = 240;
            int brightX = brightness % 65536;
            int brightY = brightness / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightX, (float)brightY);
            Tessellator tess = Tessellator.func_178181_a();
            VertexBuffer buf = tess.func_178180_c();
            AxisAlignedBB aabb = turret.getTargetProcessor().getAdjustedRange(false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_187441_d((float)5.0f);
            buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            buf.func_181662_b(0.0, aabb.field_72338_b, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buf.func_181662_b(0.0, aabb.field_72337_e, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_187441_d((float)3.0f);
            buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            buf.func_181662_b(0.0, aabb.field_72338_b, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buf.func_181662_b(0.0, aabb.field_72337_e, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_187441_d((float)3.0f);
            for (cx = aabb.field_72340_a; cx <= aabb.field_72336_d; cx += 0.5) {
                buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                buf.func_181662_b(cx, aabb.field_72338_b, aabb.field_72339_c).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(cx, aabb.field_72338_b, aabb.field_72334_f).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(cx, aabb.field_72337_e, aabb.field_72334_f).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(cx, aabb.field_72337_e, aabb.field_72339_c).func_181669_b(0, 0, 0, 255).func_181675_d();
                tess.func_78381_a();
            }
            for (cy = aabb.field_72338_b; cy <= aabb.field_72337_e; cy += 0.5) {
                buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                buf.func_181662_b(aabb.field_72340_a, cy, aabb.field_72339_c).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72340_a, cy, aabb.field_72334_f).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, cy, aabb.field_72334_f).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, cy, aabb.field_72339_c).func_181669_b(0, 0, 0, 255).func_181675_d();
                tess.func_78381_a();
            }
            for (cz = aabb.field_72339_c; cz <= aabb.field_72334_f; cz += 0.5) {
                buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                buf.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, cz).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, cz).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, cz).func_181669_b(0, 0, 0, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, cz).func_181669_b(0, 0, 0, 255).func_181675_d();
                tess.func_78381_a();
            }
            GlStateManager.func_187441_d((float)0.1f);
            for (cx = aabb.field_72340_a; cx <= aabb.field_72336_d; cx += 0.5) {
                buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                buf.func_181662_b(cx, aabb.field_72338_b, aabb.field_72339_c).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(cx, aabb.field_72338_b, aabb.field_72334_f).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(cx, aabb.field_72337_e, aabb.field_72334_f).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(cx, aabb.field_72337_e, aabb.field_72339_c).func_181669_b(255, 255, 255, 255).func_181675_d();
                tess.func_78381_a();
            }
            for (cy = aabb.field_72338_b; cy <= aabb.field_72337_e; cy += 0.5) {
                buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                buf.func_181662_b(aabb.field_72340_a, cy, aabb.field_72339_c).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72340_a, cy, aabb.field_72334_f).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, cy, aabb.field_72334_f).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, cy, aabb.field_72339_c).func_181669_b(255, 255, 255, 255).func_181675_d();
                tess.func_78381_a();
            }
            for (cz = aabb.field_72339_c; cz <= aabb.field_72334_f; cz += 0.5) {
                buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
                buf.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, cz).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, cz).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, cz).func_181669_b(255, 255, 255, 255).func_181675_d();
                buf.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, cz).func_181669_b(255, 255, 255, 255).func_181675_d();
                tess.func_78381_a();
            }
            GlStateManager.func_179121_F();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)prevBrightX, (float)prevBrightY);
            GlStateManager.func_179098_w();
        }
    }

    @Override
    public RenderLivingBase<? extends EntityLiving> getRenderer() {
        return this;
    }

    public static <T extends EntityLiving> void initialize(ITurretRenderRegistry<T> registry) {
        registry.registerRender(Turrets.CROSSBOW, new TurretRenderBase<T>(registry, ModelTurretBase::new));
        registry.registerRender(Turrets.SHOTGUN, new TurretRenderBase<T>(registry, ModelTurretShotgun::new));
        registry.registerRender(Turrets.CRYOLATOR, new TurretRenderBase<T>(registry, ModelTurretBase::new));
        registry.registerRender(Turrets.REVOLVER, new TurretRenderBase<T>(registry, ModelTurretRevolver::new));
        registry.registerRender(Turrets.MINIGUN, new TurretRenderBase<T>(registry, ModelTurretMinigun::new));
        registry.registerRender(Turrets.LASER, new TurretRenderBase<T>(registry, ModelTurretLaser::new));
        registry.registerRender(Turrets.FLAMETHROWER, new TurretRenderBase<T>(registry, ModelTurretFlamethrower::new));
        registry.registerRender(Turrets.SHIELDGEN, new TurretRenderShieldGen<T>(registry));
    }
}

