/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.turret;

import de.sanandrew.mods.turretmod.api.client.turret.ITurretRenderRegistry;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretRender;
import de.sanandrew.mods.turretmod.client.model.ModelTurretBase;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TurretRenderBase<T extends EntityLiving>
implements ITurretRender<ModelTurretBase, T> {
    final ModelTurretBase mainModel;
    final ITurretRenderRegistry<T> renderRegistry;
    final Function<Float, ModelTurretBase> modelConst;

    public TurretRenderBase(ITurretRenderRegistry<T> registry, Function<Float, ModelTurretBase> modelConst) {
        this.renderRegistry = registry;
        this.modelConst = modelConst;
        this.mainModel = this.getNewModel(0.0f);
    }

    @Override
    public ModelTurretBase getNewModel(float scale) {
        return this.modelConst.apply(Float.valueOf(scale));
    }

    @Override
    public ModelTurretBase getModel() {
        return this.mainModel;
    }

    @Override
    public void addLayers(List<LayerRenderer<T>> layerList) {
        this.renderRegistry.addUpgradeLayer(layerList);
        this.renderRegistry.addGlowLayer(layerList, this);
    }
}

