/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.world;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.turret.TurretLaser;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderTurretLaser {
    public static void render(Minecraft mc, double x, double y, double z, double partTicks) {
        Predicate<EntityTurret> chk = turretInst -> {
            if (turretInst != null && turretInst.getTurret() instanceof TurretLaser) {
                ITargetProcessor tgtProc = turretInst.getTargetProcessor();
                return tgtProc.hasAmmo() && tgtProc.isShooting() && tgtProc.hasTarget();
            }
            return false;
        };
        mc.field_71441_e.func_175644_a(EntityTurret.class, chk::test).forEach(turret -> RenderTurretLaser.renderLaser(turret, x, y, z, partTicks));
    }

    private static void renderLaser(ITurretInst turret, double renderX, double renderY, double renderZ, double partTicks) {
        Entity tgt = turret.getTargetProcessor().getTarget();
        EntityLiving turretL = turret.getEntity();
        double turretX = turretL.field_70142_S + (turretL.field_70165_t - turretL.field_70142_S) * partTicks;
        double turretY = turretL.field_70137_T + (turretL.field_70163_u - turretL.field_70137_T) * partTicks + (double)turretL.func_70047_e() - (double)(turret.isUpsideDown() ? 0.95f : 0.13f);
        double turretZ = turretL.field_70136_U + (turretL.field_70161_v - turretL.field_70136_U) * partTicks;
        double vecX = tgt.field_70142_S + (tgt.field_70165_t - tgt.field_70142_S) * partTicks - turretX;
        double vecY = tgt.field_70137_T + (tgt.field_70163_u - tgt.field_70137_T) * partTicks + (double)(tgt.field_70131_O / 1.4f) - turretY;
        double vecZ = tgt.field_70136_U + (tgt.field_70161_v - tgt.field_70136_U) * partTicks - turretZ;
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double rotYaw = (double)turretL.field_70758_at + (double)(turretL.field_70759_as - turretL.field_70758_at) * partTicks;
        double rotPtc = (double)turretL.field_70127_C + (double)(turretL.field_70125_A - turretL.field_70127_C) * partTicks;
        double beamWidth = 0.0125;
        ColorObj laserClr = new ColorObj(1.0f, 0.0f, 0.0f, 0.25f);
        if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ENDER_MEDIUM)) {
            laserClr = new ColorObj(0.0f, 0.5f, 1.0f, 0.25f);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        boolean prevLightingState = GL11.glGetBoolean((int)2896);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GlStateManager.func_179137_b((double)(turretX - renderX), (double)(turretY - renderY), (double)(turretZ - renderZ));
        GlStateManager.func_179114_b((float)(270.0f - (float)rotYaw), (float)0.0f, (float)(turret.isUpsideDown() ? -1.0f : 1.0f), (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-rotPtc)), (float)0.0f, (float)0.0f, (float)(turret.isUpsideDown() ? -1.0f : 1.0f));
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, -0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, -0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, 0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, -0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, -0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, 0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, -0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, -0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, -0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, -0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, 0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, 0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, -0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, -0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, 0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0125, -0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, -0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, -0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(dist, 0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        buffer.func_181662_b(0.0, 0.0125, 0.0125).func_181666_a(laserClr.fRed(), laserClr.fGreen(), laserClr.fBlue(), laserClr.fAlpha()).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (prevLightingState) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
    }
}

