/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.compat.jei;

import com.google.common.collect.ImmutableList;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.assembly.IRecipeEntry;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AssemblyRecipeWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> input;
    private final List<ItemStack> output;
    private final int fluxPerTick;
    private final int timeInTicks;

    public AssemblyRecipeWrapper(TurretAssemblyRegistry.RecipeKeyEntry keyEntry) {
        TurretAssemblyRegistry.RecipeEntry entry = TurretAssemblyRegistry.INSTANCE.getRecipeEntry(keyEntry.id);
        assert (entry != null) : "Recipe Entry should not be null!";
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        for (IRecipeEntry item : entry.resources) {
            inputBuilder.add(Arrays.asList(item.getEntryItemStacks()));
        }
        this.input = inputBuilder.build();
        this.fluxPerTick = entry.fluxPerTick;
        this.timeInTicks = entry.ticksProcessing;
        this.output = ImmutableList.of((Object)keyEntry.stack);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.input);
        ingredients.setOutputs(ItemStack.class, this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = Lang.translate(Lang.JEI_ASSEMBLY_ENERGY, new Object[0]) + ' ' + this.fluxPerTick * this.timeInTicks + " RF";
        minecraft.field_71466_p.func_78276_b(s, 0, 90, -8355712);
        s = Lang.translate(Lang.JEI_ASSEMBLY_TIME, new Object[0]) + ' ' + MiscUtils.getTimeFromTicks((int)this.timeInTicks);
        minecraft.field_71466_p.func_78276_b(s, 0, 100, -8355712);
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public static class Factory
    implements IRecipeWrapperFactory<TurretAssemblyRegistry.RecipeKeyEntry> {
        public IRecipeWrapper getRecipeWrapper(TurretAssemblyRegistry.RecipeKeyEntry recipe) {
            return new AssemblyRecipeWrapper(recipe);
        }
    }
}

