/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.projectile;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.Sounds;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableFloat;

public class EntityProjectileCryoCell
extends EntityTurretProjectile {
    private int level = 0;
    private int duration = 0;

    public EntityProjectileCryoCell(World world) {
        super(world);
    }

    public EntityProjectileCryoCell(World world, Entity shooter, Entity target) {
        super(world, shooter, target);
    }

    public EntityProjectileCryoCell(World world, Entity shooter, Vec3d shootingVec) {
        super(world, shooter, shootingVec);
    }

    public EntityProjectileCryoCell setLevelAndDuration(int lvl, int duration) {
        this.level = lvl;
        this.duration = duration;
        return this;
    }

    @Override
    public float getArc() {
        return 0.05f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            TurretModRebirth.proxy.spawnParticle(EnumParticle.CRYO_PARTICLE, this.field_70165_t, this.field_70163_u, this.field_70161_v, new Tuple(new Object[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        }
    }

    @Override
    public float getInitialSpeedMultiplier() {
        return 1.5f;
    }

    @Override
    public float getDamage() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthH() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthV() {
        return 0.0f;
    }

    @Override
    public boolean onPreHit(Entity e, DamageSource dmgSource, MutableFloat dmg) {
        if (!this.field_70170_p.field_72995_K && e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.duration, this.level));
            if (e instanceof EntityCreature && this.shooterCache instanceof ITurretInst) {
                TmrUtils.INSTANCE.setEntityTarget((EntityCreature)e, (ITurretInst)this.shooterCache);
            }
            this.func_184185_a(this.getRicochetSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.func_70106_y();
            return false;
        }
        return super.onPreHit(e, dmgSource, dmg);
    }

    @Override
    public SoundEvent getRicochetSound() {
        return Sounds.RICOCHET_SPLASH;
    }

    @Override
    public void onPostHit(Entity e, DamageSource dmgSource) {
        super.onPostHit(e, dmgSource);
        if (e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).field_70172_ad = 0;
        }
    }
}

