/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.projectile;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.entity.projectile.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityProjectileFlame
extends EntityTurretProjectile {
    public float damage;
    public boolean purifying;

    public EntityProjectileFlame(World world) {
        super(world);
        this.damage = 3.0f;
    }

    public EntityProjectileFlame(World world, Entity shooter, Entity target) {
        super(world, shooter, target);
        this.damage = 3.0f;
        if (shooter instanceof EntityTurret) {
            EntityTurret turret = (EntityTurret)shooter;
            float rotXZ = -turret.field_70759_as / 180.0f * (float)Math.PI;
            float rotY = -(turret.field_70125_A - 2.5f) / 180.0f * (float)Math.PI - 0.1f;
            boolean isUpsideDown = turret.isUpsideDown();
            this.field_70165_t += Math.sin(rotXZ) * (double)0.7f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
            this.field_70163_u += Math.sin(rotY) * (double)0.6f * (double)(isUpsideDown ? -1.0f : 1.0f) - (double)(isUpsideDown ? 1.0f : 0.0f);
            this.field_70161_v += Math.cos(rotXZ) * (double)0.7f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public EntityProjectileFlame(World world, Entity shooter, Vec3d shootingVec) {
        super(world, shooter, shootingVec);
    }

    @Override
    public float getArc() {
        return -0.25f;
    }

    @Override
    public float getInitialSpeedMultiplier() {
        return 0.6f;
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Override
    public float getKnockbackStrengthH() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthV() {
        return 0.0f;
    }

    @Override
    public double getScatterValue() {
        return 0.1;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return SoundEvents.field_187646_bt;
    }

    @Override
    protected void processHit(RayTraceResult hitObj) {
        this.func_184185_a(this.getRicochetSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        if (hitObj.field_72313_a != RayTraceResult.Type.ENTITY) {
            BlockPos fire;
            this.func_70106_y();
            if (this.purifying && hitObj.field_72313_a == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K && MiscUtils.RNG.randomInt(100) == 0 && this.field_70170_p.func_175623_d(fire = hitObj.func_178782_a().func_177972_a(hitObj.field_178784_b))) {
                this.field_70170_p.func_180501_a(fire, Blocks.field_150480_ab.func_176223_P(), 11);
            }
        } else if (hitObj.field_72308_g != null) {
            hitObj.field_72308_g.func_70015_d(5);
        }
    }

    @Override
    public void onPostHit(Entity e, DamageSource dmgSource) {
        super.onPostHit(e, dmgSource);
        this.damage -= 0.5f;
        if (this.damage < 0.0f) {
            this.func_70106_y();
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.purifying);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.purifying = buffer.readBoolean();
    }
}

