/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileCrossbowBolt;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TurretAmmoArrow
implements IAmmunition<EntityProjectileCrossbowBolt> {
    private final String name;
    private final UUID id;
    private final int capacity;
    private final ResourceLocation itemModel;

    public TurretAmmoArrow(boolean isMulti) {
        this.name = isMulti ? "arrow_pack" : "arrow";
        this.id = isMulti ? Ammunitions.QUIVER : Ammunitions.ARROW;
        this.capacity = isMulti ? 16 : 1;
        this.itemModel = new ResourceLocation("sapturretmod", "turret_ammo/" + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public int getAmmoCapacity() {
        return this.capacity;
    }

    @Override
    public Class<EntityProjectileCrossbowBolt> getEntityClass() {
        return EntityProjectileCrossbowBolt.class;
    }

    @Override
    public ITurret getTurret() {
        return Turrets.CROSSBOW;
    }

    @Override
    public float getInfoDamage() {
        return 3.0f;
    }

    @Override
    public UUID getTypeId() {
        return Ammunitions.ARROW;
    }

    @Override
    public UUID getGroupId() {
        return Ammunitions.ARROW;
    }

    @Override
    public String getInfoName() {
        return "arrow";
    }

    @Override
    @Nonnull
    public ItemStack getStoringAmmoItem() {
        return AmmunitionRegistry.INSTANCE.getAmmoItem(AmmunitionRegistry.INSTANCE.getType(Ammunitions.ARROW));
    }

    @Override
    public EntityProjectileCrossbowBolt getEntity(ITurretInst turretInst) {
        return new EntityProjectileCrossbowBolt(turretInst.getEntity().field_70170_p, (Entity)turretInst.getEntity(), turretInst.getTargetProcessor().getTarget());
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }
}

