/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.sanandrew.mods.sanlib.lib.function.Ex2Function;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.assembly.IRecipeEntry;
import de.sanandrew.mods.turretmod.api.assembly.ITurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.RecipeEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public final class TurretAssemblyRecipes {
    public static void initialize(ITurretAssemblyRegistry registry) {
        TmrConstants.LOG.log(Level.INFO, "Initializing Turret Assembly recipes...");
        long prevTime = System.nanoTime();
        Loader.instance().getActiveModList().forEach(mod -> TurretAssemblyRecipes.loadJsonRecipes(mod, registry));
        long timeDelta = (System.nanoTime() - prevTime) / 1000000L;
        TmrConstants.LOG.log(Level.INFO, String.format("Initializing Turret Assembly recipes done in %d ms. Found %d recipes.", timeDelta, registry.getRecipeList().size()));
    }

    private static boolean loadJsonRecipes(ModContainer mod, ITurretAssemblyRegistry registry) {
        return MiscUtils.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/recipes_sapturretmod/assembly/"), root -> TurretAssemblyRecipes.preProcessJson(root, registry), (root, file) -> TurretAssemblyRecipes.processRecipeJson(file, registry));
    }

    private static boolean preProcessJson(Path root, ITurretAssemblyRegistry registry) {
        if (Files.exists(root, new LinkOption[0])) {
            try {
                Files.find(root, Integer.MAX_VALUE, (filePth, attr) -> FilenameUtils.getName((String)filePth.toString()).startsWith("group_"), new FileVisitOption[0]).forEach(file -> TurretAssemblyRecipes.processJson(file, (Ex2Function<JsonObject, Boolean, JsonParseException, IOException>)((Ex2Function)json -> TurretAssemblyRecipes.registerJsonGroup(json, registry))));
            }
            catch (IOException ex) {
                TmrConstants.LOG.log(Level.ERROR, String.format("Couldn't read recipe group from directory %s", root), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private static boolean processRecipeJson(Path file, ITurretAssemblyRegistry registry) {
        return FilenameUtils.getName((String)file.toString()).startsWith("group_") || TurretAssemblyRecipes.processJson(file, (Ex2Function<JsonObject, Boolean, JsonParseException, IOException>)((Ex2Function)json -> TurretAssemblyRecipes.registerJsonRecipes(json, registry)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean processJson(Path file, Ex2Function<JsonObject, Boolean, JsonParseException, IOException> callback) {
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) return true;
        if (FilenameUtils.getName((String)file.toString()).startsWith("_")) {
            return true;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject json = (JsonObject)JsonUtils.fromJson((Reader)reader, JsonObject.class);
            if (json == null) throw new JsonSyntaxException("Json cannot be null");
            if (json.isJsonNull()) {
                throw new JsonSyntaxException("Json cannot be null");
            }
            callback.apply((Object)json);
            boolean bl = true;
            return bl;
        }
        catch (JsonParseException e) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Parsing error loading assembly table recipe from %s", file), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Couldn't read recipe from %s", file), (Throwable)e);
            return false;
        }
    }

    private static boolean registerJsonGroup(JsonObject json, ITurretAssemblyRegistry registry) throws JsonParseException, IOException {
        String groupName = JsonUtils.getStringVal((JsonElement)json.get("name"));
        ItemStack groupIcon = JsonUtils.getItemStack((JsonElement)json.get("item"));
        registry.registerGroup(groupName, groupIcon);
        return true;
    }

    private static boolean registerJsonRecipes(JsonObject json, ITurretAssemblyRegistry registry) throws JsonParseException, IOException {
        String id = JsonUtils.getStringVal((JsonElement)json.get("id"));
        String group = JsonUtils.getStringVal((JsonElement)json.get("group"));
        int fluxPerTick = JsonUtils.getIntVal((JsonElement)json.get("fluxPerTick"));
        int ticksProcessing = JsonUtils.getIntVal((JsonElement)json.get("ticksProcessing"));
        ItemStack result = JsonUtils.getItemStack((JsonElement)json.get("result"));
        JsonElement ingredients = json.get("ingredients");
        if (!ingredients.isJsonArray()) {
            throw new JsonSyntaxException("Ingredients must be an array");
        }
        ArrayList entries = new ArrayList();
        ingredients.getAsJsonArray().forEach(elem -> {
            if (elem != null && elem.isJsonObject()) {
                JsonObject elemObj = elem.getAsJsonObject();
                int count = JsonUtils.getIntVal((JsonElement)elemObj.get("count"));
                boolean showTooltipText = JsonUtils.getBoolVal((JsonElement)elemObj.get("showTooltipText"), (boolean)false);
                NonNullList items = JsonUtils.getItemStacks((JsonElement)elemObj.get("items"));
                int sz = items.size();
                if (sz > 0) {
                    RecipeEntry entry = new RecipeEntry(count).put((ItemStack[])items.toArray((Object[])new ItemStack[sz]));
                    if (showTooltipText) {
                        entry.drawTooltip();
                    }
                    entries.add(entry);
                }
            }
        });
        return registry.registerRecipe(UUID.fromString(id), registry.getGroup(group), result, fluxPerTick, ticksProcessing, entries.toArray(new IRecipeEntry[entries.size()]));
    }
}

