/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.electrolytegen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public class ElectrolyteRegistry {
    private static final Map<ItemStack, Fuel> FUELS_INTRN = new HashMap<ItemStack, Fuel>();
    private static final Map<ItemStack, Fuel> FUELS_UNMODIFY = Collections.unmodifiableMap(FUELS_INTRN);
    public static final Fuel NULL_FUEL = new Fuel(-1.0f, -1, ItemStackUtils.getEmpty(), ItemStackUtils.getEmpty());

    public static void initialize() {
        TmrConstants.LOG.log(Level.INFO, "Initializing Electrolyte Generator recipes...");
        long prevTime = System.nanoTime();
        Loader.instance().getActiveModList().forEach(ElectrolyteRegistry::loadJsonRecipes);
        long timeDelta = (System.nanoTime() - prevTime) / 1000000L;
        TmrConstants.LOG.log(Level.INFO, String.format("Initializing Electrolyte Generator recipes done in %d ms. Found %d recipes.", timeDelta, ElectrolyteRegistry.getFuelMap().size()));
    }

    private static boolean loadJsonRecipes(ModContainer mod) {
        return MiscUtils.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/recipes_sapturretmod/electrolytegen/"), null, ElectrolyteRegistry::processJson);
    }

    private static boolean processJson(Path root, Path file) {
        if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || root.relativize(file).toString().startsWith("_")) {
            return true;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject json = (JsonObject)JsonUtils.fromJson((Reader)reader, JsonObject.class);
            if (json == null || json.isJsonNull()) {
                throw new JsonSyntaxException("Json cannot be null");
            }
            NonNullList inputItems = JsonUtils.getItemStacks((JsonElement)json.get("electrolytes"));
            float effectiveness = JsonUtils.getFloatVal((JsonElement)json.get("effectiveness"));
            int ticksProcessing = JsonUtils.getIntVal((JsonElement)json.get("timeProcessing"));
            ItemStack trash = ItemStackUtils.getEmpty();
            ItemStack treasure = ItemStackUtils.getEmpty();
            JsonElement elem = json.get("trash");
            if (elem != null && !elem.isJsonNull()) {
                trash = JsonUtils.getItemStack((JsonElement)elem);
            }
            if ((elem = json.get("treasure")) != null && !elem.isJsonNull()) {
                treasure = JsonUtils.getItemStack((JsonElement)elem);
            }
            ElectrolyteRegistry.registerFuels((NonNullList<ItemStack>)inputItems, effectiveness, ticksProcessing, trash, treasure);
        }
        catch (JsonParseException e) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Parsing error loading electrolyte generator recipe from %s", file), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Couldn't read recipe from %s", file), (Throwable)e);
            return false;
        }
        return true;
    }

    public static Map<ItemStack, Fuel> getFuelMap() {
        return FUELS_UNMODIFY;
    }

    @Nonnull
    public static Fuel getFuel(ItemStack stack) {
        if (!ItemStackUtils.isValid((ItemStack)stack)) {
            return NULL_FUEL;
        }
        for (Map.Entry<ItemStack, Fuel> entry : FUELS_INTRN.entrySet()) {
            ItemStack key = entry.getKey();
            if (!ItemStackUtils.areEqual((ItemStack)key, (ItemStack)stack, (boolean)key.func_77942_o(), (boolean)false, (key.func_77952_i() == Short.MAX_VALUE ? 1 : 0) != 0)) continue;
            return entry.getValue();
        }
        return NULL_FUEL;
    }

    public static boolean isFuel(ItemStack stack) {
        return !ElectrolyteRegistry.getFuel(stack).isNull();
    }

    public static boolean registerFuels(NonNullList<ItemStack> electrolytes, float effectiveness, int ticksProcessing, @Nonnull ItemStack trash, @Nonnull ItemStack treasure) {
        if (effectiveness < 1.0f) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot have an effectiveness of less than 1.0");
            return false;
        }
        if (ticksProcessing < 1) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot have a time less than 1 tick");
            return false;
        }
        if (electrolytes.stream().anyMatch(item -> !ElectrolyteRegistry.getFuel(item).isNull())) {
            TmrConstants.LOG.log(Level.ERROR, "Electrolyte item is already registered");
            return false;
        }
        Fuel fuelInst = new Fuel(effectiveness, ticksProcessing, trash, treasure);
        electrolytes.forEach(item -> FUELS_INTRN.put((ItemStack)item, fuelInst));
        return true;
    }

    public static boolean removeFuel(ItemStack stack) {
        Iterator<Map.Entry<ItemStack, Fuel>> it = FUELS_INTRN.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ItemStack, Fuel> entry = it.next();
            ItemStack key = entry.getKey();
            if (!ItemStackUtils.areEqual((ItemStack)key, (ItemStack)stack, (boolean)key.func_77942_o(), (boolean)false, (key.func_77952_i() == Short.MAX_VALUE ? 1 : 0) != 0)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public static final class Fuel {
        public final float effect;
        public final short ticksProc;
        @Nonnull
        public final ItemStack trash;
        @Nonnull
        public final ItemStack treasure;

        public Fuel(float effectiveness, int ticksProcessing, @Nonnull ItemStack trash, @Nonnull ItemStack treasure) {
            this.effect = effectiveness;
            this.ticksProc = (short)ticksProcessing;
            this.trash = trash;
            this.treasure = treasure;
        }

        public boolean isNull() {
            return this.effect < 1.0f || this.ticksProc < 1;
        }
    }
}

