/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.turretmod.api.client.event.OpenTcuGuiEvent;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTCU;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.event.OpenTcuContainerEvent;
import de.sanandrew.mods.turretmod.api.turret.IGuiTcuRegistry;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.gui.tcu.GuiTcuContainer;
import de.sanandrew.mods.turretmod.client.gui.tcu.GuiTcuScreen;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import de.sanandrew.mods.turretmod.inventory.ContainerTurretUpgrades;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncTcuGuis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class GuiTcuRegistry
implements IGuiTcuRegistry {
    public static final ResourceLocation GUI_INFO = new ResourceLocation("sapturretmod", "info");
    public static final ResourceLocation GUI_TARGETS_MOB = new ResourceLocation("sapturretmod", "targets_creature");
    public static final ResourceLocation GUI_TARGETS_PLAYER = new ResourceLocation("sapturretmod", "targets_player");
    public static final ResourceLocation GUI_TARGETS_SMART = new ResourceLocation("sapturretmod", "targets_smart");
    public static final ResourceLocation GUI_UPGRADES = new ResourceLocation("sapturretmod", "upgrades");
    public static final List<ResourceLocation> GUI_RESOURCES = new ArrayList<ResourceLocation>();
    public static final GuiTcuRegistry INSTANCE = new GuiTcuRegistry();
    @SideOnly(value=Side.CLIENT)
    private static Map<ResourceLocation, GuiEntry> guis;
    private static Map<ResourceLocation, BiFunction<EntityPlayer, ITurretInst, Container>> containers;

    private GuiTcuRegistry() {
    }

    @SideOnly(value=Side.CLIENT)
    public Gui openGUI(int type, EntityPlayer player, ITurretInst turretInst) {
        OpenTcuGuiEvent event;
        GuiEntry entry;
        if (type >= 0 && type < GUI_RESOURCES.size() && (entry = this.getGuiEntry(GUI_RESOURCES.get(type))) != null && !MinecraftForge.EVENT_BUS.post((Event)(event = new OpenTcuGuiEvent(player, turretInst, entry.factory)))) {
            IGuiTCU guiDelegate = event.factory.get();
            Container cnt = guiDelegate.getContainer(player, turretInst);
            if (cnt != null) {
                return new GuiTcuContainer(GUI_RESOURCES.get(type), guiDelegate, cnt, turretInst);
            }
            return new GuiTcuScreen(GUI_RESOURCES.get(type), guiDelegate, turretInst);
        }
        return null;
    }

    public GuiEntry getGuiEntry(ResourceLocation location) {
        return guis.get(location);
    }

    public Container openContainer(int type, EntityPlayer player, ITurretInst turretInst) {
        ResourceLocation loc;
        OpenTcuContainerEvent event;
        if (type >= 0 && type < GUI_RESOURCES.size() && !MinecraftForge.EVENT_BUS.post((Event)(event = new OpenTcuContainerEvent(player, turretInst, containers.get(loc = GUI_RESOURCES.get(type))))) && event.factory != null) {
            return event.factory.apply(player, turretInst);
        }
        return null;
    }

    @Override
    public void registerGuiEntry(ResourceLocation location, int position, @Nullable BiFunction<EntityPlayer, ITurretInst, Container> containerFactory) {
        if (containers == null) {
            containers = new HashMap<ResourceLocation, BiFunction<EntityPlayer, ITurretInst, Container>>();
        }
        if (position >= GUI_RESOURCES.size()) {
            GUI_RESOURCES.add(location);
        } else {
            GUI_RESOURCES.set(position, location);
        }
        containers.put(location, containerFactory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerGui(ResourceLocation location, ItemStack icon, Supplier<IGuiTCU> factory, Function<IGuiTcuInst<?>, Boolean> canShowTabFunc) {
        if (guis == null) {
            guis = new HashMap<ResourceLocation, GuiEntry>();
        }
        guis.put(location, new GuiEntry(() -> icon, factory, canShowTabFunc));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerGui(ResourceLocation location, Supplier<ItemStack> iconSupplier, Supplier<IGuiTCU> factory, Function<IGuiTcuInst<?>, Boolean> canShowTabFunc) {
        if (guis == null) {
            guis = new HashMap<ResourceLocation, GuiEntry>();
        }
        guis.put(location, new GuiEntry(iconSupplier, factory, canShowTabFunc));
    }

    public static void initialize(IGuiTcuRegistry registry) {
        registry.registerGuiEntry(GUI_INFO, 0, null);
        registry.registerGuiEntry(GUI_TARGETS_MOB, 1, null);
        registry.registerGuiEntry(GUI_TARGETS_PLAYER, 2, null);
        registry.registerGuiEntry(GUI_TARGETS_SMART, 3, null);
        registry.registerGuiEntry(GUI_UPGRADES, 4, (player, turretInst) -> new ContainerTurretUpgrades((IInventory)player.field_71071_by, (UpgradeProcessor)turretInst.getUpgradeProcessor()));
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && !event.getWorld().field_72995_K) {
            PacketRegistry.sendToPlayer((IMessage)new PacketSyncTcuGuis(), (EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            PacketRegistry.sendToAll((IMessage)new PacketSyncTcuGuis());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class GuiEntry {
        final Supplier<ItemStack> icon;
        final Function<IGuiTcuInst<?>, Boolean> canShowTabFunc;
        final Supplier<IGuiTCU> factory;

        GuiEntry(Supplier<ItemStack> icon, Supplier<IGuiTCU> factory, Function<IGuiTcuInst<?>, Boolean> canShowTabFunc) {
            this.icon = icon;
            this.factory = factory;
            this.canShowTabFunc = canShowTabFunc;
        }

        public boolean showTab(IGuiTcuInst<?> gui) {
            return this.canShowTabFunc == null || this.canShowTabFunc.apply(gui) != false;
        }

        public ItemStack getIcon() {
            return this.icon.get();
        }
    }
}

