/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRegistry;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import org.apache.logging.log4j.Level;

public final class TurretRegistry
implements ITurretRegistry {
    public static final TurretRegistry INSTANCE = new TurretRegistry();
    public static final ITurret NULL_TURRET = new EmptyTurret();
    private final Map<UUID, ITurret> turretFromUUID = new HashMap<UUID, ITurret>();
    private final Map<Class<? extends ITurret>, ITurret> turretFromClass = new HashMap<Class<? extends ITurret>, ITurret>();
    private final List<ITurret> turrets = new ArrayList<ITurret>();

    private TurretRegistry() {
    }

    @Override
    public List<ITurret> getTurrets() {
        return new ArrayList<ITurret>(this.turrets);
    }

    @Override
    public ITurret getTurret(UUID uuid) {
        return (ITurret)MiscUtils.defIfNull((Object)this.turretFromUUID.get(uuid), (Object)NULL_TURRET);
    }

    @Override
    public ITurret getTurret(Class<? extends ITurret> clazz) {
        return (ITurret)MiscUtils.defIfNull((Object)this.turretFromClass.get(clazz), (Object)NULL_TURRET);
    }

    @Override
    public boolean registerTurret(ITurret type) {
        if (type == null) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot register NULL as Turret-Info!", (Throwable)new InvalidParameterException());
            return false;
        }
        if (type.getName() == null || type.getName().isEmpty()) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Turret-Info %s has an empty/NULL name! Cannot register the Void.", type.getClass().getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        if (this.turretFromUUID.containsKey(type.getId())) {
            TmrConstants.LOG.log(Level.ERROR, String.format("The UUID of Turret-Info %s is already registered! Use another UUID. JUST DO IT!", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        this.turretFromUUID.put(type.getId(), type);
        this.turretFromClass.put(type.getClass(), type);
        this.turrets.add(type);
        return true;
    }

    @Override
    @Nonnull
    public ItemStack getTurretItem(ITurret type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get turret_placer item with NULL type!");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("turretUUID", type.getId().toString());
        ItemStack stack = new ItemStack((Item)ItemRegistry.TURRET_PLACER, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack getTurretItem(ITurretInst turretInst) {
        ItemStack stack = this.getTurretItem(turretInst.getTurret());
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            EntityLiving turretL = turretInst.getEntity();
            nbt.func_74776_a("turretHealth", turretL.func_110143_aJ());
            if (turretL.func_145818_k_()) {
                nbt.func_74778_a("turretName", turretL.func_95999_t());
            }
        }
        return stack;
    }

    @Override
    public ITurret getTurret(@Nonnull ItemStack stack) {
        String id;
        NBTTagCompound nbt;
        if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_PLACER) && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("turretUUID") && UuidUtils.isStringUuid((String)(id = nbt.func_74779_i("turretUUID")))) {
            return INSTANCE.getTurret(UUID.fromString(id));
        }
        return NULL_TURRET;
    }

    private static class EmptyTurret
    implements ITurret {
        private static final AxisAlignedBB BB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

        private EmptyTurret() {
        }

        @Override
        public String getName() {
            return "empty";
        }

        @Override
        @Nonnull
        public UUID getId() {
            return UuidUtils.EMPTY_UUID;
        }

        @Override
        public ResourceLocation getItemModel() {
            return null;
        }

        @Override
        public ResourceLocation getStandardTexture(ITurretInst turretInst) {
            return null;
        }

        @Override
        public ResourceLocation getGlowTexture(ITurretInst turretInst) {
            return null;
        }

        @Override
        public SoundEvent getShootSound(ITurretInst turretInst) {
            return null;
        }

        @Override
        public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
            return BB;
        }

        @Override
        public int getTier() {
            return 0;
        }

        @Override
        public ITurretInfo getInfo() {
            return MyInfo.INSTANCE;
        }

        public static final class MyInfo
        implements ITurretInfo {
            static final ITurretInfo INSTANCE = new MyInfo();

            @Override
            public float getHealth() {
                return 0.0f;
            }

            @Override
            public int getAmmoCapacity() {
                return 0;
            }

            @Override
            public String getRange() {
                return "n/a";
            }
        }
    }
}

