/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.shieldgen;

import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldTurret;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class ShieldHandler {
    public static final List<Function<Entity, Entity>> PROJ_GET_OWNER = new ArrayList<Function<Entity, Entity>>();
    private static final WeakHashMap<ITurretInst, WeakHashMap<Entity, Integer>> ALREADY_PUSHED = new WeakHashMap();

    public static void onTargeting(ITurretInst turretInst, ITargetProcessor processor) {
        ShieldTurret shield = (ShieldTurret)turretInst.getRAM(null);
        EntityLiving turretL = turretInst.getEntity();
        boolean hasPushed = false;
        boolean hasTarget = false;
        ArrayList<Entity> recognizedEntities = new ArrayList<Entity>();
        if (processor.canShoot()) {
            if (shield != null && shield.getValue() > 0.0f) {
                for (Entity target : processor.getValidTargetList()) {
                    double dZ;
                    double dY;
                    double dX;
                    if (ShieldHandler.knockBackEntity(turretInst, target, 1.0f, dX = turretInst.getEntity().field_70165_t - target.field_70165_t, dY = turretInst.getEntity().field_70163_u - target.field_70163_u, dZ = turretInst.getEntity().field_70161_v - target.field_70161_v)) {
                        if (target instanceof EntityCreature) {
                            TmrUtils.INSTANCE.setEntityTarget((EntityCreature)target, processor.getTurret());
                        }
                        hasPushed = true;
                        shield.damage(1.0f);
                        turretInst.updateState();
                        hasTarget = true;
                        if (shield.getValue() <= 0.0f) break;
                    }
                    recognizedEntities.add(target);
                }
            }
            if (shield != null && shield.getValue() > 0.0f) {
                for (Entity projectile : turretL.field_70170_p.func_72872_a(Entity.class, processor.getAdjustedRange(true))) {
                    Optional<Entity> opOwner = PROJ_GET_OWNER.stream().map(func -> (Entity)func.apply(projectile)).filter(owner -> owner != null && processor.isEntityTargeted((Entity)owner)).findFirst();
                    if (!opOwner.isPresent()) continue;
                    double dX = turretInst.getEntity().field_70165_t - projectile.field_70165_t;
                    double dY = turretInst.getEntity().field_70163_u - projectile.field_70163_u;
                    double dZ = turretInst.getEntity().field_70161_v - projectile.field_70161_v;
                    if (ShieldHandler.knockBackEntity(turretInst, projectile, 0.5f, dX, dY, dZ)) {
                        if (opOwner.get() instanceof EntityCreature) {
                            TmrUtils.INSTANCE.setEntityTarget((EntityCreature)opOwner.get(), processor.getTurret());
                        }
                        hasPushed = true;
                        shield.damage(1.0f);
                        turretInst.updateState();
                        hasTarget = true;
                        if (shield.getValue() <= 0.0f) break;
                    }
                    recognizedEntities.add(projectile);
                }
            }
        }
        if (hasTarget) {
            if (hasPushed) {
                processor.setShot(true);
                processor.getTurret().updateState();
            } else if (!processor.isShooting()) {
                processor.decrInitShootTicks();
            }
        } else {
            processor.resetInitShootTicks();
        }
        if (ALREADY_PUSHED.containsKey(turretInst)) {
            ALREADY_PUSHED.get(turretInst).entrySet().removeIf(entry -> entry.getKey() == null || (Integer)entry.getValue() < turretInst.getEntity().field_70173_aa || !recognizedEntities.contains(entry.getKey()));
        }
        ALREADY_PUSHED.entrySet().removeIf(entry -> entry.getKey() == null || ((WeakHashMap)entry.getValue()).isEmpty());
    }

    public static void onExplosion(ITurretInst turretInst, AxisAlignedBB explosionBB, List<BlockPos> blocksAffected, List<Entity> entitiesAffected) {
        AxisAlignedBB turretBB = turretInst.getTargetProcessor().getAdjustedRange(true);
        if (turretBB.func_72326_a(explosionBB)) {
            blocksAffected.removeIf(blockPos -> {
                ShieldTurret shield;
                if (turretInst.getEntity().field_70170_p.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && turretBB.func_72326_a(new AxisAlignedBB(blockPos)) && (shield = (ShieldTurret)turretInst.getRAM(null)) != null && shield.isShieldActive()) {
                    shield.damage(2.0f);
                    return true;
                }
                return false;
            });
            entitiesAffected.removeIf(entity -> {
                ShieldTurret shield;
                if (turretBB.func_72326_a(entity.func_174813_aQ()) && !turretInst.getTargetProcessor().isEntityTargeted((Entity)entity) && (shield = (ShieldTurret)turretInst.getRAM(null)) != null && shield.isShieldActive()) {
                    shield.damage(2.0f);
                    return true;
                }
                return false;
            });
            turretInst.updateState();
        }
    }

    public static boolean knockBackEntity(ITurretInst turretInst, Entity entity, float strength, double xRatio, double yRatio, double zRatio) {
        boolean hasBeenPushed;
        boolean bl = hasBeenPushed = ALREADY_PUSHED.containsKey(turretInst) && ALREADY_PUSHED.get(turretInst).getOrDefault(entity, -1) > turretInst.getEntity().field_70173_aa;
        if (hasBeenPushed) {
            return false;
        }
        entity.field_70160_al = true;
        double avgRatio = Math.sqrt(xRatio * xRatio + yRatio * yRatio + zRatio * zRatio) * 1.0;
        entity.field_70181_x /= 2.0;
        entity.field_70159_w = -xRatio / avgRatio * (double)strength;
        entity.field_70181_x = Math.abs(yRatio) < (double)0.1f ? 0.4 : -yRatio * 2.0 / avgRatio * (double)strength;
        entity.field_70179_y = -zRatio / avgRatio * (double)strength;
        if (entity.field_70122_E) {
            entity.field_70181_x /= 2.0;
            entity.field_70181_x += (double)strength;
            if (entity.field_70181_x > 0.4) {
                entity.field_70181_x = 0.4;
            }
        }
        if (entity.field_70170_p instanceof WorldServer) {
            ((WorldServer)entity.field_70170_p).func_73039_n().func_151247_a((Entity)turretInst.getEntity(), (Packet)new SPacketEntityVelocity(entity));
        }
        ALREADY_PUSHED.computeIfAbsent(turretInst, inst -> new WeakHashMap()).put(entity, turretInst.getEntity().field_70173_aa + 20);
        return true;
    }

    static {
        PROJ_GET_OWNER.add(proj -> {
            if (proj instanceof EntityArrow) {
                return ((EntityArrow)proj).field_70250_c;
            }
            if (proj instanceof EntityThrowable) {
                return ((EntityThrowable)proj).func_85052_h();
            }
            if (proj instanceof EntityLlamaSpit) {
                return ((EntityLlamaSpit)proj).field_190539_a;
            }
            if (proj instanceof EntityFireball) {
                return ((EntityFireball)proj).field_70235_a;
            }
            return null;
        });
    }
}

