/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.shieldgen;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldTurret;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.util.Resources;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class TurretForcefield
implements ITurret {
    public static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "turrets/turret_forcefield");
    public static final UUID ID = UUID.fromString("95C3D0DC-000E-4E2D-9551-C9C897E072DC");
    private static final AxisAlignedBB RANGE_BB_I = new AxisAlignedBB(-8.0, -2.0, -8.0, 8.0, 8.0, 8.0);
    private static final AxisAlignedBB RANGE_BB_II = new AxisAlignedBB(-16.0, -2.0, -16.0, 16.0, 16.0, 16.0);
    private static final AxisAlignedBB RANGE_BB_III = new AxisAlignedBB(-24.0, -2.0, -24.0, 24.0, 24.0, 24.0);

    @Override
    public void applyEntityAttributes(ITurretInst turretInst) {
        turretInst.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(1.0);
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_INIT_SHOOT_TICKS).func_111128_a(0.0);
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111128_a(512.0);
    }

    @Override
    public void onUpdate(ITurretInst turretInst) {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        shield.onTick();
    }

    @Override
    public void writeSpawnData(ITurretInst turretInst, ByteBuf buf) {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        buf.writeFloat(shield.value);
        buf.writeFloat(shield.recovery);
    }

    @Override
    public void readSpawnData(ITurretInst turretInst, ByteBuf buf) {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        shield.value = buf.readFloat();
        shield.recovery = buf.readFloat();
    }

    @Override
    public void writeSyncData(ITurretInst turretInst, ObjectOutputStream stream) throws IOException {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        stream.writeFloat(shield.value);
        stream.writeFloat(shield.recovery);
    }

    @Override
    public void readSyncData(ITurretInst turretInst, ObjectInputStream stream) throws IOException {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        shield.value = stream.readFloat();
        shield.recovery = stream.readFloat();
    }

    @Override
    public void onSave(ITurretInst turretInst, NBTTagCompound nbt) {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        nbt.func_74776_a("shieldValue", shield.value);
        nbt.func_74776_a("shieldRecovery", shield.recovery);
    }

    @Override
    public void onLoad(ITurretInst turretInst, NBTTagCompound nbt) {
        ShieldTurret shield = turretInst.getRAM(() -> new ShieldTurret(turretInst));
        shield.value = nbt.func_74760_g("shieldValue");
        shield.recovery = nbt.func_74760_g("shieldRecovery");
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_SHIELDGEN.getResource();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_SHIELDGEN_GLOW.getResource();
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        IUpgradeProcessor upgProc = turretInst.getUpgradeProcessor();
        return upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_II) ? RANGE_BB_III : (upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_I) ? RANGE_BB_II : RANGE_BB_I);
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return null;
    }

    @Override
    public String getName() {
        return "ii_shieldgen";
    }

    @Override
    public UUID getId() {
        return ID;
    }

    @Override
    public ResourceLocation getItemModel() {
        return ITEM_MODEL;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public ITurretInfo getInfo() {
        return MyInfo.INSTANCE;
    }

    @Override
    public boolean canSeeThroughBlocks() {
        return true;
    }

    @Override
    public float getDeactiveHeadPitch() {
        return 0.0f;
    }

    public static final class MyInfo
    implements ITurretInfo {
        static final ITurretInfo INSTANCE = new MyInfo();

        @Override
        public float getHealth() {
            return 30.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 512;
        }

        @Override
        public String getRange() {
            return "20";
        }
    }
}

