/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class UpgradeBasic
implements ITurretUpgrade {
    private final String name;
    private final Function<ITurret, Boolean> isTurretApplicable;
    private final ResourceLocation itemModel;
    private final ITurretUpgrade dependantOn;

    public UpgradeBasic(String name, Function<ITurret, Boolean> isTurretApplicable) {
        this.name = name;
        this.isTurretApplicable = Objects.requireNonNull(isTurretApplicable);
        this.itemModel = new ResourceLocation("sapturretmod", "upgrades/" + name);
        this.dependantOn = null;
    }

    public UpgradeBasic(String name, Function<ITurret, Boolean> isTurretApplicable, ITurretUpgrade dependantOn) {
        this.name = name;
        this.isTurretApplicable = Objects.requireNonNull(isTurretApplicable);
        this.itemModel = new ResourceLocation("sapturretmod", "upgrades/" + name);
        this.dependantOn = dependantOn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }

    @Override
    public boolean isTurretApplicable(ITurret turret) {
        return this.isTurretApplicable.apply(turret);
    }

    @Override
    public ITurretUpgrade getDependantOn() {
        return this.dependantOn;
    }
}

