/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgradeRegistry;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public final class UpgradeRegistry
implements IUpgradeRegistry {
    public static final UpgradeRegistry INSTANCE = new UpgradeRegistry();
    public static final UUID EMPTY = UuidUtils.EMPTY_UUID;
    private static final ITurretUpgrade EMPTY_INST;
    private Map<UUID, ITurretUpgrade> uuidToUpgradeMap = new HashMap<UUID, ITurretUpgrade>();
    private Map<ITurretUpgrade, UUID> upgradeToUuidMap = new LinkedHashMap<ITurretUpgrade, UUID>();
    private List<String> errored = new ArrayList<String>();

    private UpgradeRegistry() {
    }

    @Override
    public void registerUpgrade(UUID uuid, ITurretUpgrade upgrade) {
        this.uuidToUpgradeMap.put(uuid, upgrade);
        this.upgradeToUuidMap.put(upgrade, uuid);
    }

    @Override
    public ITurretUpgrade getUpgrade(UUID uuid) {
        return (ITurretUpgrade)MiscUtils.defIfNull((Object)this.uuidToUpgradeMap.get(uuid), (Object)EMPTY_INST);
    }

    @Override
    public UUID getUpgradeId(ITurretUpgrade upg) {
        return (UUID)MiscUtils.defIfNull((Object)this.upgradeToUuidMap.get(upg), (Object)EMPTY);
    }

    @Override
    public UUID getUpgradeId(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return EMPTY;
        }
        String uid = ((NBTTagCompound)MiscUtils.defIfNull((Object)stack.func_77978_p(), (Object)new NBTTagCompound())).func_74779_i("upgradeId");
        try {
            return UUID.fromString(uid);
        }
        catch (IllegalArgumentException ex) {
            if (!this.errored.contains(uid)) {
                TmrConstants.LOG.log(Level.WARN, "There was an error at parsing the UUID for a turret_placer upgrade item!", (Throwable)ex);
                this.errored.add(uid);
            }
            return EMPTY;
        }
    }

    @Override
    public ITurretUpgrade getUpgrade(@Nonnull ItemStack stack) {
        if (!ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_UPGRADE) || !stack.func_77942_o()) {
            return EMPTY_INST;
        }
        return this.getUpgrade(this.getUpgradeId(stack));
    }

    @Override
    public List<ITurretUpgrade> getUpgrades() {
        return new ArrayList<ITurretUpgrade>(this.upgradeToUuidMap.keySet());
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem(UUID uuid) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("upgradeId", uuid.toString());
        ItemStack stack = new ItemStack((Item)ItemRegistry.TURRET_UPGRADE, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem(ITurretUpgrade upgrade) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("upgradeId", this.getUpgradeId(upgrade).toString());
        ItemStack stack = new ItemStack((Item)ItemRegistry.TURRET_UPGRADE, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    static {
        INSTANCE.registerUpgrade(EMPTY, new EmptyUpgrade());
        EMPTY_INST = UpgradeRegistry.INSTANCE.uuidToUpgradeMap.get(EMPTY);
    }

    static final class EmptyUpgrade
    implements ITurretUpgrade {
        private static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "upgrades/empty");

        EmptyUpgrade() {
        }

        @Override
        public String getName() {
            return "empty";
        }

        @Override
        public ResourceLocation getModel() {
            return ITEM_MODEL;
        }

        @Override
        public boolean isTurretApplicable(ITurret turret) {
            return false;
        }
    }
}

