/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import net.minecraft.util.ResourceLocation;

public abstract class UpgradeUpgStorage
implements ITurretUpgrade {
    private final ResourceLocation itemModel;
    private final String name;

    public UpgradeUpgStorage(String name) {
        this.name = name;
        this.itemModel = new ResourceLocation("sapturretmod", "upgrades/" + name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }

    @Override
    public boolean isTurretApplicable(ITurret turret) {
        return true;
    }

    public static class UpgradeStorageMK3
    extends UpgradeUpgStorage {
        private final ITurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(Upgrades.UPG_STORAGE_II);

        public UpgradeStorageMK3() {
            super("upg_storage_iii");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return this.dependant;
        }
    }

    public static class UpgradeStorageMK2
    extends UpgradeUpgStorage {
        private final ITurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(Upgrades.UPG_STORAGE_I);

        public UpgradeStorageMK2() {
            super("upg_storage_ii");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return this.dependant;
        }
    }

    public static class UpgradeStorageMK1
    extends UpgradeUpgStorage {
        public UpgradeStorageMK1() {
            super("upg_storage_i");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return null;
        }
    }
}

