/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades.shield;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.shield.ShieldPersonal;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class UpgradeShieldPersonal
implements ITurretUpgrade {
    private static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "upgrades/pers_shield");
    private final String name;

    public UpgradeShieldPersonal() {
        this.name = "pers_shield";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceLocation getModel() {
        return ITEM_MODEL;
    }

    @Override
    public boolean isTurretApplicable(ITurret turret) {
        return true;
    }

    @Override
    public void onApply(ITurretInst turretInst) {
        UUID upgId = UpgradeRegistry.INSTANCE.getUpgradeId(this);
        ShieldPersonal shield = new ShieldPersonal(20.0f);
        turretInst.getUpgradeProcessor().setUpgradeInstance(upgId, shield);
    }

    @Override
    public void onLoad(ITurretInst turretInst, NBTTagCompound nbt) {
        UUID upgId = UpgradeRegistry.INSTANCE.getUpgradeId(this);
        ShieldPersonal shield = new ShieldPersonal(nbt.func_74760_g("shieldValue"));
        shield.recovery = nbt.func_74760_g("shieldRecovery");
        turretInst.getUpgradeProcessor().setUpgradeInstance(upgId, shield);
    }

    @Override
    public void onSave(ITurretInst turretInst, NBTTagCompound nbt) {
        UUID upgId = UpgradeRegistry.INSTANCE.getUpgradeId(this);
        ShieldPersonal shield = (ShieldPersonal)turretInst.getUpgradeProcessor().getUpgradeInstance(upgId);
        if (shield != null) {
            nbt.func_74776_a("shieldValue", shield.value);
            nbt.func_74776_a("shieldRecovery", shield.recovery);
        }
    }

    @Override
    public void onRemove(ITurretInst turretInst) {
        UUID upgId = UpgradeRegistry.INSTANCE.getUpgradeId(this);
        ((ShieldPersonal)turretInst.getUpgradeProcessor().getUpgradeInstance((UUID)upgId)).value = 0.0f;
        turretInst.getUpgradeProcessor().delUpgradeInstance(upgId);
    }
}

