/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.assembly;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.item.ItemAssemblyUpgrade;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.INBTSerializable;

class AssemblyInventoryHandler
implements ISidedInventory,
INBTSerializable<NBTTagCompound> {
    private final NonNullList<ItemStack> assemblyStacks = NonNullList.func_191197_a((int)23, (Object)ItemStackUtils.getEmpty());
    private static final int[] SLOTS_INSERT = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
    private static final int[] SLOTS_EXTRACT = new int[]{0};
    private final TileEntityTurretAssembly tile;

    AssemblyInventoryHandler(TileEntityTurretAssembly tile) {
        this.tile = tile;
    }

    private boolean isStackAcceptable(@Nonnull ItemStack stack, int insrtSlot) {
        if (this.hasFilterUpgrade()) {
            NonNullList<ItemStack> filter = this.getFilterStacks();
            if (ItemStackUtils.isStackInList((ItemStack)stack, filter)) {
                return ItemStackUtils.areEqual((ItemStack)stack, (ItemStack)((ItemStack)filter.get(insrtSlot)));
            }
            return !ItemStackUtils.isValid((ItemStack)((ItemStack)filter.get(insrtSlot)));
        }
        return true;
    }

    NonNullList<ItemStack> getFilterStacks() {
        if (this.hasFilterUpgrade()) {
            return ItemAssemblyUpgrade.Filter.getFilterStacks((ItemStack)this.assemblyStacks.get(3));
        }
        return ItemAssemblyUpgrade.Filter.getEmptyInv();
    }

    boolean hasAutoUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.assemblyStacks.get(1)), (Item)ItemRegistry.ASSEMBLY_UPG_AUTO);
    }

    boolean hasSpeedUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.assemblyStacks.get(2)), (Item)ItemRegistry.ASSEMBLY_UPG_SPEED);
    }

    boolean hasFilterUpgrade() {
        return ItemStackUtils.isItem((ItemStack)((ItemStack)this.assemblyStacks.get(3)), (Item)ItemRegistry.ASSEMBLY_UPG_FILTER);
    }

    boolean canFillOutput() {
        ItemStack invStack = (ItemStack)this.assemblyStacks.get(0);
        return !ItemStackUtils.isValid((ItemStack)invStack) || invStack.func_190916_E() < invStack.func_77976_d();
    }

    boolean canFillOutput(ItemStack stack) {
        ItemStack invStack = (ItemStack)this.assemblyStacks.get(0);
        return this.canFillOutput() && ItemStackUtils.canStack((ItemStack)invStack, (ItemStack)stack, (boolean)true);
    }

    void fillOutput(ItemStack stack) {
        if (ItemStackUtils.isValid((ItemStack)((ItemStack)this.assemblyStacks.get(0)))) {
            ((ItemStack)this.assemblyStacks.get(0)).func_190917_f(stack.func_190916_E());
        } else {
            this.assemblyStacks.set(0, (Object)stack.func_77946_l());
            this.func_70296_d();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_EXTRACT : (side == EnumFacing.UP ? new int[]{} : SLOTS_INSERT);
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack) && side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack stack, EnumFacing side) {
        return slot == 0 && side == EnumFacing.DOWN;
    }

    public int func_70302_i_() {
        return this.assemblyStacks.size();
    }

    public boolean func_191420_l() {
        return this.assemblyStacks.stream().noneMatch(ItemStackUtils::isValid);
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.assemblyStacks.get(slot);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int size) {
        if (!this.hasAutoUpgrade()) {
            this.tile.automate = false;
        }
        if (ItemStackUtils.isValid((ItemStack)((ItemStack)this.assemblyStacks.get(slot)))) {
            if (((ItemStack)this.assemblyStacks.get(slot)).func_190916_E() <= size) {
                ItemStack itemstack = (ItemStack)this.assemblyStacks.get(slot);
                this.assemblyStacks.set(slot, (Object)ItemStackUtils.getEmpty());
                if (slot <= 4) {
                    this.func_70296_d();
                }
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.assemblyStacks.get(slot)).func_77979_a(size);
            if (((ItemStack)this.assemblyStacks.get(slot)).func_190916_E() == 0) {
                this.assemblyStacks.set(slot, (Object)ItemStackUtils.getEmpty());
            }
            if (slot <= 4) {
                this.func_70296_d();
            }
            return itemstack;
        }
        return ItemStackUtils.getEmpty();
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        if (ItemStackUtils.isValid((ItemStack)((ItemStack)this.assemblyStacks.get(slot)))) {
            ItemStack itemstack = (ItemStack)this.assemblyStacks.get(slot);
            this.assemblyStacks.set(slot, (Object)ItemStackUtils.getEmpty());
            if (slot <= 4) {
                this.func_70296_d();
            }
            return itemstack;
        }
        return ItemStackUtils.getEmpty();
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        if (!this.hasAutoUpgrade()) {
            this.tile.automate = false;
        }
        this.assemblyStacks.set(slot, (Object)stack);
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (slot <= 4) {
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.tile.getCustomName();
    }

    public boolean func_145818_k_() {
        return this.tile.hasCustomName();
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.tile.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        BlockPos tilePos = this.tile.func_174877_v();
        return this.tile.func_145831_w().func_175625_s(tilePos) == this.tile && player.func_70092_e((double)tilePos.func_177958_n() + 0.5, (double)tilePos.func_177956_o() + 0.5, (double)tilePos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return slot != 0 && ItemStackUtils.isValid((ItemStack)stack) && (slot > 4 && this.isStackAcceptable(stack, slot - 5) || slot == 1 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_AUTO || slot == 2 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_SPEED || slot == 3 && stack.func_77973_b() == ItemRegistry.ASSEMBLY_UPG_FILTER);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.assemblyStacks.size(); ++i) {
            this.assemblyStacks.set(i, (Object)ItemStackUtils.getEmpty());
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("inventory", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.assemblyStacks, (int)64));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        ItemStackUtils.readItemStacksFromTag(this.assemblyStacks, (NBTTagList)nbt.func_150295_c("inventory", 10));
    }
}

