/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.assembly;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.network.PacketSyncTileEntity;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.tileentity.assembly.AssemblyEnergyStorage;
import de.sanandrew.mods.turretmod.tileentity.assembly.AssemblyInventoryHandler;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityTurretAssembly
extends TileEntity
implements TileClientSync,
ITickable {
    public static final int MAX_FLUX_STORAGE = 75000;
    public static final int MAX_FLUX_INSERT = 500;
    public float robotArmX = 2.0f;
    public float robotArmY = -9.0f;
    public float prevRobotArmX;
    public float prevRobotArmY;
    public float robotMotionX = 0.0f;
    public float robotMotionY = 0.0f;
    public float robotEndX;
    public float robotEndY;
    public Tuple spawnParticle;
    private boolean prevActive;
    boolean automate;
    public boolean isActive;
    private boolean isActiveClient;
    public Tuple currCrafting;
    int ticksCrafted = 0;
    int maxTicksCrafted = 0;
    int fluxConsumption = 0;
    boolean doSync = false;
    private long ticksExisted = 0L;
    private String customName;
    final AssemblyEnergyStorage energyStorage = new AssemblyEnergyStorage();
    final AssemblyInventoryHandler invHandler = new AssemblyInventoryHandler(this);
    final IItemHandler itemHandlerBottom = new SidedInvWrapper((ISidedInventory)this.invHandler, EnumFacing.DOWN);
    final IItemHandler itemHandlerSide = new SidedInvWrapper((ISidedInventory)this.invHandler, EnumFacing.WEST);

    public void beginCrafting(UUID recipe, int count) {
        if (this.currCrafting != null && recipe.equals(this.currCrafting.getValue(0)) && !this.automate) {
            ItemStack result = TurretAssemblyRegistry.INSTANCE.getRecipeResult(recipe);
            ItemStack currCrfStack = (ItemStack)this.currCrafting.getValue(1);
            if (currCrfStack.func_190916_E() + count < 1) {
                this.cancelCrafting();
            } else if (ItemStackUtils.isValid((ItemStack)result) && currCrfStack.func_190916_E() + count * result.func_190916_E() <= currCrfStack.func_77976_d()) {
                currCrfStack.func_190917_f(count);
                this.doSync = true;
            } else {
                currCrfStack.func_190920_e(currCrfStack.func_77976_d());
                this.doSync = true;
            }
        } else if (this.currCrafting == null) {
            ItemStack stackRes = TurretAssemblyRegistry.INSTANCE.getRecipeResult(recipe);
            TurretAssemblyRegistry.RecipeEntry entry = TurretAssemblyRegistry.INSTANCE.getRecipeEntry(recipe);
            if (entry != null && ItemStackUtils.isValid((ItemStack)stackRes)) {
                stackRes = stackRes.func_77946_l();
                stackRes.func_190920_e(this.automate ? 1 : count);
                this.currCrafting = new Tuple(new Object[]{recipe, stackRes});
                this.maxTicksCrafted = entry.ticksProcessing;
                this.doSync = true;
            }
        }
    }

    public void cancelCrafting() {
        this.currCrafting = null;
        this.ticksCrafted = 0;
        this.fluxConsumption = 0;
        this.maxTicksCrafted = 0;
        this.isActive = false;
        this.isActiveClient = false;
        this.doSync = true;
        this.func_70296_d();
    }

    private void initCrafting() {
        if (this.currCrafting != null && this.invHandler.canFillOutput()) {
            UUID currCrfUUID = (UUID)this.currCrafting.getValue(0);
            ItemStack addStacks = ((ItemStack)this.currCrafting.getValue(1)).func_77946_l();
            ItemStack recipe = TurretAssemblyRegistry.INSTANCE.getRecipeResult(currCrfUUID);
            if (ItemStackUtils.isValid((ItemStack)recipe)) {
                TurretAssemblyRegistry.RecipeEntry currentlyCrafted;
                addStacks.func_190920_e(recipe.func_190916_E());
                if (this.invHandler.canFillOutput(addStacks) && TurretAssemblyRegistry.INSTANCE.checkAndConsumeResources((IInventory)this.invHandler, currCrfUUID) && (currentlyCrafted = TurretAssemblyRegistry.INSTANCE.getRecipeEntry(currCrfUUID)) != null) {
                    this.maxTicksCrafted = currentlyCrafted.ticksProcessing;
                    this.fluxConsumption = MathHelper.func_76123_f((float)((float)currentlyCrafted.fluxPerTick * (this.hasSpeedUpgrade() ? 1.1f : 1.0f)));
                    this.ticksCrafted = 0;
                    this.isActive = true;
                    this.doSync = true;
                }
            } else {
                this.cancelCrafting();
            }
        }
    }

    public boolean hasAutoUpgrade() {
        return this.invHandler.hasAutoUpgrade();
    }

    public boolean hasSpeedUpgrade() {
        return this.invHandler.hasSpeedUpgrade();
    }

    public boolean hasFilterUpgrade() {
        return this.invHandler.hasFilterUpgrade();
    }

    public NonNullList<ItemStack> getFilterStacks() {
        return this.invHandler.getFilterStacks();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.automate && !this.hasAutoUpgrade()) {
                this.automate = false;
                this.cancelCrafting();
            }
            if (this.energyStorage.hasFluxChanged()) {
                this.doSync = true;
            }
            this.energyStorage.updatePrevFlux();
            int maxLoop = this.hasSpeedUpgrade() ? 4 : 1;
            boolean markDirty = false;
            this.isActiveClient = this.isActive;
            if (this.isActive && this.currCrafting != null) {
                for (int i = 0; i < maxLoop; ++i) {
                    if (this.energyStorage.fluxAmount >= this.fluxConsumption && this.field_145850_b.func_175687_A(this.field_174879_c) == 0) {
                        this.energyStorage.fluxAmount -= this.fluxConsumption;
                        if (++this.ticksCrafted >= this.maxTicksCrafted) {
                            ItemStack stack = TurretAssemblyRegistry.INSTANCE.getRecipeResult((UUID)this.currCrafting.getValue(0));
                            if (!ItemStackUtils.isValid((ItemStack)stack)) {
                                this.cancelCrafting();
                                return;
                            }
                            this.invHandler.fillOutput(stack);
                            if (!this.invHandler.canFillOutput(stack)) {
                                this.isActive = false;
                                this.isActiveClient = false;
                            }
                            if (((ItemStack)this.currCrafting.getValue(1)).func_190916_E() > 1 || this.automate) {
                                if (!this.automate) {
                                    ((ItemStack)this.currCrafting.getValue(1)).func_190918_g(1);
                                }
                                if (!TurretAssemblyRegistry.INSTANCE.checkAndConsumeResources((IInventory)this.invHandler, (UUID)this.currCrafting.getValue(0))) {
                                    this.isActive = false;
                                    this.isActiveClient = false;
                                }
                            } else if (!this.automate) {
                                this.cancelCrafting();
                                return;
                            }
                            this.ticksCrafted = 0;
                            markDirty = true;
                        }
                        this.doSync = true;
                    } else {
                        this.isActiveClient = false;
                        this.doSync = true;
                    }
                    if (this.isActive && this.currCrafting != null) {
                        continue;
                    }
                    break;
                }
            } else {
                this.initCrafting();
                this.isActiveClient = false;
            }
            if (markDirty) {
                this.func_70296_d();
            }
            if (this.doSync) {
                PacketSyncTileEntity.sync(this);
                this.doSync = false;
            }
        } else {
            this.processRobotArm();
        }
        this.prevActive = this.isActive;
        ++this.ticksExisted;
    }

    private void processRobotArm() {
        this.prevRobotArmX = this.robotArmX;
        this.prevRobotArmY = this.robotArmY;
        this.robotArmX += this.robotMotionX;
        this.robotArmY += this.robotMotionY;
        if (this.robotArmX > this.robotEndX && this.robotMotionX > 0.0f) {
            this.robotArmX = this.robotEndX;
            this.robotMotionX = 0.0f;
        } else if (this.robotArmX < this.robotEndX && this.robotMotionX < 0.0f) {
            this.robotArmX = this.robotEndX;
            this.robotMotionX = 0.0f;
        }
        if (this.robotArmY > this.robotEndY && this.robotMotionY > 0.0f) {
            this.robotArmY = this.robotEndY;
            this.robotMotionY = 0.0f;
        } else if (this.robotArmY < this.robotEndY && this.robotMotionY < 0.0f) {
            this.robotArmY = this.robotEndY;
            this.robotMotionY = 0.0f;
        }
        if (this.isActiveClient && (!this.prevActive || this.ticksExisted % 20L == 0L)) {
            this.animateRobotArmRng();
        } else if (this.prevActive && !this.isActiveClient) {
            this.animateRobotArmReset();
            this.spawnParticle = null;
        }
        if (this.isActiveClient && this.spawnParticle != null) {
            TurretModRebirth.proxy.spawnParticle(EnumParticle.ASSEMBLY_SPARK, (Double)this.spawnParticle.getValue(0), (Double)this.spawnParticle.getValue(1) + 0.05, (Double)this.spawnParticle.getValue(2), null);
            this.spawnParticle = null;
        }
    }

    private void animateRobotArmRng() {
        float endX = 4.0f + MiscUtils.RNG.randomFloat() * 6.0f;
        float endY = -3.5f + MiscUtils.RNG.randomFloat() * -6.0f;
        this.robotMotionX = (0.1f + MiscUtils.RNG.randomFloat() * 0.1f) * (endX > this.robotArmX ? 1.0f : -1.0f);
        this.robotMotionY = (0.1f + MiscUtils.RNG.randomFloat() * 0.1f) * (endY > this.robotArmY ? 1.0f : -1.0f);
        this.robotEndX = endX;
        this.robotEndY = endY;
    }

    private void animateRobotArmReset() {
        float endX = 2.0f;
        float endY = -9.0f;
        this.robotMotionX = (0.1f + MiscUtils.RNG.randomFloat() * 0.1f) * (endX > this.robotArmX ? 1.0f : -1.0f);
        this.robotMotionY = (0.1f + MiscUtils.RNG.randomFloat() * 0.1f) * (endY > this.robotArmY ? 1.0f : -1.0f);
        this.robotEndX = endX;
        this.robotEndY = endY;
    }

    public IInventory getInventory() {
        return this.invHandler;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readNBT(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.writeNBT(super.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.writeNBT(new NBTTagCompound()));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
        this.doSync = true;
    }

    private NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)this.invHandler.serializeNBT());
        if (this.currCrafting != null) {
            nbt.func_74778_a("craftingUUID", this.currCrafting.getValue(0).toString());
            ItemStackUtils.writeStackToTag((ItemStack)((ItemStack)this.currCrafting.getValue(1)), (NBTTagCompound)nbt, (String)"craftingStack");
        }
        nbt.func_74782_a("cap_energy", (NBTBase)this.energyStorage.serializeNBT());
        nbt.func_74757_a("isActive", this.isActive);
        nbt.func_74768_a("ticksCrafted", this.ticksCrafted);
        nbt.func_74768_a("maxTicksCrafted", this.maxTicksCrafted);
        nbt.func_74768_a("fluxConsumption", this.fluxConsumption);
        nbt.func_74757_a("automate", this.automate);
        if (this.hasCustomName()) {
            nbt.func_74778_a("customName", this.customName);
        }
        return nbt;
    }

    private void readNBT(NBTTagCompound nbt) {
        this.invHandler.deserializeNBT(nbt.func_74775_l("inventory"));
        if (nbt.func_74764_b("craftingUUID") && nbt.func_74764_b("craftingStack")) {
            this.currCrafting = new Tuple(new Object[]{UUID.fromString(nbt.func_74779_i("craftingUUID")), new ItemStack(nbt.func_74775_l("craftingStack"))});
        }
        this.energyStorage.deserializeNBT(nbt.func_74775_l("cap_energy"));
        this.isActive = nbt.func_74767_n("isActive");
        this.ticksCrafted = nbt.func_74762_e("ticksCrafted");
        this.maxTicksCrafted = nbt.func_74762_e("maxTicksCrafted");
        this.fluxConsumption = nbt.func_74762_e("fluxConsumption");
        this.automate = nbt.func_74767_n("automate");
        if (nbt.func_74764_b("customName")) {
            this.customName = nbt.func_74779_i("customName");
        }
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getCustomName()) : new TextComponentTranslation(this.getCustomName(), new Object[0]);
    }

    public int getTicksCrafted() {
        return this.ticksCrafted;
    }

    public int getMaxTicksCrafted() {
        return this.maxTicksCrafted;
    }

    public int getFluxConsumption() {
        return this.fluxConsumption;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energyStorage.fluxAmount);
        buf.writeInt(this.fluxConsumption);
        buf.writeBoolean(this.isActive);
        buf.writeInt(this.ticksCrafted);
        buf.writeInt(this.maxTicksCrafted);
        buf.writeBoolean(this.automate);
        buf.writeBoolean(this.isActiveClient);
        if (this.currCrafting != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.currCrafting.getValue(1)));
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.currCrafting.getValue(0).toString());
        } else {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)ItemStackUtils.getEmpty());
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.energyStorage.fluxAmount = buf.readInt();
        this.fluxConsumption = buf.readInt();
        this.isActive = buf.readBoolean();
        this.ticksCrafted = buf.readInt();
        this.maxTicksCrafted = buf.readInt();
        this.automate = buf.readBoolean();
        this.isActiveClient = buf.readBoolean();
        ItemStack crfStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.currCrafting = ItemStackUtils.isValid((ItemStack)crfStack) ? new Tuple(new Object[]{UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)), crfStack}) : null;
    }

    public void setAutomated(boolean b) {
        if (this.currCrafting == null) {
            this.automate = b;
            this.doSync = true;
        }
    }

    public boolean isAutomated() {
        return this.automate;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.itemHandlerBottom;
            }
            if (facing != EnumFacing.UP) {
                return (T)this.itemHandlerSide;
            }
        } else if (facing != EnumFacing.UP && capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing != EnumFacing.UP) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
        }
        return super.hasCapability(capability, facing);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.hasCustomName() ? this.customName : "sapturretmod.container.assembly";
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }
}

