/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.electrolytegen;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteRegistry;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

final class ElectrolyteInventoryHandler
extends ItemStackHandler {
    private final TileEntityElectrolyteGenerator tile;

    public ElectrolyteInventoryHandler(TileEntityElectrolyteGenerator tile) {
        super(14);
        this.tile = tile;
    }

    boolean canAddExtraction(@Nonnull ItemStack stack) {
        ItemStack myStack = stack.func_77946_l();
        for (int i = 9; i < 14 && ItemStackUtils.isValid((ItemStack)myStack); ++i) {
            myStack = super.insertItem(i, myStack, true);
        }
        return !ItemStackUtils.isValid((ItemStack)myStack);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        if (slot < 9 && !ElectrolyteRegistry.getFuel(stack).isNull() && !ItemStackUtils.isValid((ItemStack)((ItemStack)this.stacks.get(slot)))) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    void addExtraction(@Nonnull ItemStack stack) {
        ItemStack myStack = stack.func_77946_l();
        for (int i = 9; i < 14 && ItemStackUtils.isValid((ItemStack)myStack); ++i) {
            myStack = super.insertItem(i, myStack, false);
        }
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return slot < 9 ? 1 : super.getStackLimit(slot, stack);
    }

    @Nonnull
    ItemStack extractInsertItem(int slot, boolean simulate) {
        if (slot < 9) {
            return super.extractItem(slot, 1, simulate);
        }
        return ItemStackUtils.getEmpty();
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot > 8) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStackUtils.getEmpty();
    }

    NonNullList<ItemStack> getStacksArray() {
        return this.stacks;
    }

    protected void onLoad() {
        super.onLoad();
        this.tile.containerItemHandler.onLoad();
    }
}

