/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.util;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TmrCreativeTabs {
    private static final Comparator<ItemStack> ITM_NAME_COMP = new ItemNameComparator();
    public static final CreativeTabs TURRETS = new CreativeTabs("sapturretmod:turrets"){
        private NonNullList<ItemStack> tabIcons = null;

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return this.func_151244_d();
        }

        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public ItemStack func_151244_d() {
            if (this.tabIcons == null) {
                this.tabIcons = NonNullList.func_191196_a();
                ItemRegistry.TURRET_PLACER.func_150895_a(ItemRegistry.TURRET_PLACER, this, this.tabIcons);
            }
            return (ItemStack)this.tabIcons.get((int)(System.currentTimeMillis() / 4250L) % this.tabIcons.size());
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> itmList) {
            super.func_78018_a(itmList);
            itmList.sort((itm1, itm2) -> {
                if (itm1 != null && itm1.func_77973_b() == ItemRegistry.TURRET_PLACER) {
                    return itm2 != null && itm2.func_77973_b() == ItemRegistry.TURRET_PLACER ? 0 : -2;
                }
                if (itm2 != null && itm2.func_77973_b() == ItemRegistry.TURRET_PLACER) {
                    return 2;
                }
                if (itm1 != null && itm1.func_77973_b() == ItemRegistry.TURRET_AMMO) {
                    return itm2 != null && itm2.func_77973_b() == ItemRegistry.TURRET_AMMO ? 0 : -1;
                }
                if (itm2 != null && itm2.func_77973_b() == ItemRegistry.TURRET_AMMO) {
                    return 1;
                }
                return 0;
            });
        }
    };
    public static final CreativeTabs MISC = new CreativeTabs("sapturretmod:misc"){
        @Nonnull
        private ItemStack currTabIcon = ItemStackUtils.getEmpty();

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            if (!ItemStackUtils.isValid((ItemStack)this.currTabIcon)) {
                this.currTabIcon = new ItemStack((Item)ItemRegistry.TURRET_CONTROL_UNIT, 1);
            }
            return this.currTabIcon;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> itmList) {
            super.func_78018_a(itmList);
            itmList.sort((itm1, itm2) -> {
                if (itm1 != null && itm1.func_77973_b() instanceof ItemBlock) {
                    return itm2 != null && itm2.func_77973_b() instanceof ItemBlock ? 0 : -2;
                }
                if (itm2 != null && itm2.func_77973_b() instanceof ItemBlock) {
                    return 2;
                }
                if (itm1 != null && itm1.func_77973_b() == ItemRegistry.REPAIR_KIT) {
                    return itm2 != null && itm2.func_77973_b() == ItemRegistry.REPAIR_KIT ? 0 : 1;
                }
                if (itm2 != null && itm2.func_77973_b() == ItemRegistry.REPAIR_KIT) {
                    return -1;
                }
                return 0;
            });
        }
    };
    public static final CreativeTabs UPGRADES = new CreativeTabs("sapturretmod:upgrades"){
        private NonNullList<ItemStack> tabIcons = null;

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return this.func_151244_d();
        }

        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public ItemStack func_151244_d() {
            if (this.tabIcons == null) {
                this.tabIcons = NonNullList.func_191196_a();
                ItemRegistry.TURRET_UPGRADE.func_150895_a(ItemRegistry.TURRET_PLACER, this, this.tabIcons);
            }
            return (ItemStack)this.tabIcons.get((int)(System.currentTimeMillis() / 4250L) % this.tabIcons.size());
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> itmList) {
            super.func_78018_a(itmList);
            TmrCreativeTabs.sortItemsByName(itmList);
            TmrCreativeTabs.sortItemsBySubItems(itmList, this);
        }
    };

    protected static void sortItemsByName(NonNullList<ItemStack> items) {
        items.sort(ITM_NAME_COMP);
    }

    protected static void sortItemsBySubItems(NonNullList<ItemStack> items, CreativeTabs tab) {
        items.sort((Comparator)new ItemSubComparator(tab));
    }

    private static class ItemSubComparator
    implements Comparator<ItemStack> {
        private final CreativeTabs tab;

        private ItemSubComparator(CreativeTabs thisTab) {
            this.tab = thisTab;
        }

        @Override
        public int compare(@Nonnull ItemStack o1, @Nonnull ItemStack o2) {
            if (o1.func_77973_b() != o2.func_77973_b()) {
                return -1;
            }
            NonNullList subItms = NonNullList.func_191196_a();
            o1.func_77973_b().func_150895_a((Item)ItemRegistry.TURRET_PLACER, this.tab, subItms);
            return Integer.compare(ItemSubComparator.getStackIndexInList(o1, (List<ItemStack>)subItms), ItemSubComparator.getStackIndexInList(o2, (List<ItemStack>)subItms));
        }

        private static int getStackIndexInList(@Nonnull ItemStack stack, List<ItemStack> stackArray) {
            for (ItemStack stackElem : stackArray) {
                if (!ItemStackUtils.areEqual((ItemStack)stack, (ItemStack)stackElem, (boolean)true)) continue;
                return stackArray.indexOf(stackElem);
            }
            return -1;
        }
    }

    private static class ItemNameComparator
    implements Comparator<ItemStack> {
        private ItemNameComparator() {
        }

        @Override
        public int compare(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
            return stack2.func_77977_a().compareTo(stack1.func_77977_a());
        }
    }
}

