/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.util;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import de.sanandrew.mods.turretmod.api.ITmrPlugin;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.TmrPlugin;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteRegistry;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldHandler;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.util.CommonProxy;
import de.sanandrew.mods.turretmod.util.CraftingRecipes;
import de.sanandrew.mods.turretmod.util.TmrConfiguration;
import de.sanandrew.mods.turretmod.util.TmrInternalPlugin;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="sapturretmod", version="4.0.0-beta.3", name="Turret Mod Rebirth", guiFactory="de.sanandrew.mods.turretmod.client.gui.config.TmrGuiFactory", dependencies="required-after:forge@[13.20.1.2516,];required-after:sanlib@[1.3.0,]", acceptedMinecraftVersions="[1.11.2]")
public class TurretModRebirth {
    public static final String GUI_FACTORY = "de.sanandrew.mods.turretmod.client.gui.config.TmrGuiFactory";
    public static SimpleNetworkWrapper network;
    private static final String MOD_PROXY_CLIENT = "de.sanandrew.mods.turretmod.client.util.ClientProxy";
    private static final String MOD_PROXY_COMMON = "de.sanandrew.mods.turretmod.util.CommonProxy";
    public static final List<ITmrPlugin> PLUGINS;
    @Mod.Instance(value="sapturretmod")
    public static TurretModRebirth instance;
    @SidedProxy(modId="sapturretmod", clientSide="de.sanandrew.mods.turretmod.client.util.ClientProxy", serverSide="de.sanandrew.mods.turretmod.util.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().autogenerated = false;
        TurretModRebirth.loadPlugins(event.getAsmData());
        TmrConfiguration.initConfiguration(event);
        network = NetworkRegistry.INSTANCE.newSimpleChannel("SapTurretModNWCH");
        PacketRegistry.initialize();
        PLUGINS.forEach(plugin -> plugin.preInit(TmrUtils.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerTurrets(TurretRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerAmmo(AmmunitionRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerRepairKits(RepairKitRegistry.INSTANCE));
        PLUGINS.forEach(plugin -> plugin.registerUpgrades(UpgradeRegistry.INSTANCE));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PLUGINS.forEach(plugin -> plugin.registerAssemblyRecipes(TurretAssemblyRegistry.INSTANCE));
        ElectrolyteRegistry.initialize();
        CraftingRecipes.initialize();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PLUGINS.forEach(ITmrPlugin::postInit);
        TargetProcessor.initialize();
        proxy.postInit(event);
        TurretAssemblyRegistry.INSTANCE.finalizeRegistry();
    }

    @Mod.EventHandler
    public void interModComm(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(message -> {
            Optional msgFunc;
            if (message.key.equals("sapturretmod:checkProjForShield") && message.isFunctionMessage() && (msgFunc = message.getFunctionValue(Entity.class, Entity.class)).isPresent()) {
                ShieldHandler.PROJ_GET_OWNER.add(arg_0 -> ((Function)((Function)msgFunc.get())).apply(arg_0));
            }
        });
    }

    private static void loadPlugins(ASMDataTable dataTable) {
        String annotationClassName = TmrPlugin.class.getCanonicalName();
        Set asmDatas = dataTable.getAll(annotationClassName);
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<ITmrPlugin> asmInstanceClass = asmClass.asSubclass(ITmrPlugin.class);
                ITmrPlugin instance = asmInstanceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                PLUGINS.add(instance);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                TmrConstants.LOG.error("Failed to load: {}", new Object[]{asmData.getClassName(), e});
            }
        }
        PLUGINS.sort((p1, p2) -> p1 instanceof TmrInternalPlugin ? -1 : (p2 instanceof TmrInternalPlugin ? 1 : 0));
    }

    static {
        PLUGINS = new ArrayList<ITmrPlugin>();
    }
}

