/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.api;

import de.sanandrew.mods.turretmod.api.IRegistryObject;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public interface IRegistry<T extends IRegistryObject> {
    public void register(@Nonnull T var1);

    default public void registerAll(T ... objects) {
        Arrays.stream(objects).forEach(this::register);
    }

    @Nonnull
    public Collection<T> getObjects();

    @Nonnull
    public T getObject(ResourceLocation var1);

    @Nonnull
    public T getObject(ItemStack var1);

    @Nonnull
    public T getDefaultObject();

    @Nonnull
    default public ItemStack getItem(ResourceLocation id) {
        throw new UnsupportedOperationException("Cannot create item! This registry does not register items.");
    }

    default public boolean isEqual(@Nonnull T obj1, @Nonnull T obj2) {
        return obj1.isValid() && obj2.isValid() && obj1.getId().equals((Object)obj2.getId());
    }

    default public boolean isEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return this.isEqual(this.getObject(stack1), this.getObject(stack2));
    }
}

