/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.api.ammo;

import de.sanandrew.mods.turretmod.api.IRegistryObject;
import de.sanandrew.mods.turretmod.api.ammo.IProjectileInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import org.apache.commons.lang3.mutable.MutableFloat;

public interface IProjectile
extends IRegistryObject {
    public float getSpeed();

    public float getArc();

    public float getDamage();

    public float getKnockbackHorizontal();

    public float getKnockbackVertical();

    public SoundEvent getRicochetSound();

    public double getScatterValue();

    default public DamageSource getCustomDamageSrc(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, TargetType type) {
        return null;
    }

    default public void onCreate(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile) {
    }

    default public void onUpdate(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile) {
    }

    default public boolean onHit(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, RayTraceResult hitObj) {
        return true;
    }

    default public boolean onDamageEntityPre(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, DamageSource damageSrc, MutableFloat damage) {
        return !(target instanceof EntityWither) || !((EntityWither)target).func_82205_o() || !damageSrc.func_76352_a();
    }

    default public void onDamageEntityPost(@Nullable ITurretInst turret, @Nonnull IProjectileInst projectile, Entity target, DamageSource damageSrc) {
    }

    default public float getSpeedMultiplierAir() {
        return 1.0f;
    }

    default public float getSpeedMultiplierLiquid(float viscosity) {
        return 0.8f * (2.0f - viscosity);
    }

    public static enum TargetType {
        REGULAR,
        SPECIAL_ENDERMAN,
        SPECIAL_ENDER_DRAGON,
        SPECIAL_WITHER;

    }
}

