/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.api.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;

public class AssemblyIngredient
extends Ingredient {
    private final int count;
    private final NonNullList<ItemStack> itemList;
    private ItemStack[] items;
    private IntList itemIds;

    public AssemblyIngredient(int count, ItemStack ... stacks) {
        super(0);
        this.itemList = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])stacks);
        this.count = count;
    }

    public AssemblyIngredient(int count, String ... ores) {
        super(0);
        this.itemList = Arrays.stream(ores).map(OreDictionary::getOres).collect(NonNullList::func_191196_a, AbstractCollection::addAll, AbstractCollection::addAll);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.items == null || this.items.length != this.itemList.size()) {
            NonNullList lst = NonNullList.func_191196_a();
            for (ItemStack stack : this.itemList) {
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, lst);
                    continue;
                }
                lst.add((Object)stack);
            }
            this.items = (ItemStack[])lst.toArray((Object[])new ItemStack[0]);
        }
        return this.items;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.itemIds == null || this.itemIds.size() != this.itemList.size()) {
            this.items = new ItemStack[0];
            this.itemIds = (IntList)Arrays.stream(this.func_193365_a()).map(RecipeItemHelper::func_194113_b).collect(Collectors.toCollection(() -> new IntArrayList(this.itemList.size())));
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (ItemStack target : this.itemList) {
            if (!ItemStackUtils.areEqualNbtFit((ItemStack)input, (ItemStack)target, (boolean)false, (boolean)true, (boolean)false) || input.func_190916_E() < this.count) continue;
            return true;
        }
        return false;
    }

    protected void invalidate() {
        this.itemIds = null;
        this.items = null;
    }

    public boolean isSimple() {
        return true;
    }

    public static AssemblyIngredient fromJson(@Nullable JsonElement json, JsonContext ctx) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                JsonObject jsonObj = json.getAsJsonObject();
                int count = JsonUtils.getIntVal((JsonElement)jsonObj.get("count"), (int)1);
                Ingredient defIng = CraftingHelper.getIngredient((JsonElement)jsonObj.get("items"), (JsonContext)ctx);
                return new AssemblyIngredient(count, defIng.func_193365_a());
            }
            throw new JsonSyntaxException("Assembly Table Ingredient needs to be object");
        }
        throw new JsonSyntaxException("Assembly Table Ingredient cannot be null");
    }
}

