/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.api.turret;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public interface ITargetProcessor {
    public static final EventBus TARGET_BUS = new EventBus();

    public boolean addAmmo(@Nonnull ItemStack var1);

    public boolean addAmmo(@Nonnull ItemStack var1, ICapabilityProvider var2);

    public int getAmmoCount();

    @Nonnull
    public ItemStack getAmmoStack();

    public boolean hasAmmo();

    public void dropExcessAmmo();

    public void decrAmmo();

    public void putAmmoInInventory(ICapabilityProvider var1);

    public boolean isAmmoApplicable(@Nonnull ItemStack var1);

    public ApplyType getAmmoApplyType(@Nonnull ItemStack var1);

    public int getMaxAmmoCapacity();

    public int getMaxShootTicks();

    public boolean isShooting();

    public boolean canShoot();

    public void setShot(boolean var1);

    public void decrInitShootTicks();

    public void resetInitShootTicks();

    public Entity getProjectile();

    public double getRangeVal();

    public AxisAlignedBB getAdjustedRange(boolean var1);

    public boolean shootProjectile();

    public void playSound(SoundEvent var1, float var2);

    public boolean isEntityValidTarget(Entity var1);

    public List<Entity> getValidTargetList();

    public boolean isEntityTargeted(Entity var1);

    public boolean isPlayerTargeted(UUID var1);

    public boolean isEntityTargeted(ResourceLocation var1);

    public ITurretInst getTurretInst();

    public boolean hasTarget();

    public Entity getTarget();

    public void writeToNbt(NBTTagCompound var1);

    public void readFromNbt(NBTTagCompound var1);

    public ResourceLocation[] getEnabledEntityTargets();

    public UUID[] getEnabledPlayerTargets();

    public Map<ResourceLocation, Boolean> getEntityTargets();

    public Map<UUID, Boolean> getPlayerTargets();

    public void updateEntityTarget(ResourceLocation var1, boolean var2);

    public void updatePlayerTarget(UUID var1, boolean var2);

    public void updateEntityTargets(ResourceLocation[] var1);

    public void updatePlayerTargets(UUID[] var1);

    public String getTargetName();

    public void onTick();

    public void onTickClient();

    public boolean isEntityBlacklist();

    public boolean isPlayerBlacklist();

    public void setEntityBlacklist(boolean var1);

    public void setPlayerBlacklist(boolean var1);

    public static enum ApplyType {
        ADD,
        REPLACE,
        NOT_COMPATIBLE;

    }
}

