/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Range;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

@SideOnly(value=Side.CLIENT)
public class ComponentAmmoStatProcessor
implements IComponentProcessor {
    private IAmmunition[] ammo;

    public void setup(IVariableProvider<String> provider) {
        this.ammo = (IAmmunition[])Arrays.stream(((String)provider.get("ammo_type")).split(";")).map(id -> AmmunitionRegistry.INSTANCE.getObject(new ResourceLocation(id))).toArray(IAmmunition[]::new);
    }

    public String process(String s) {
        String langCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        Range<Float> ammoDmg = this.ammo[0].getDamageInfo();
        float min = ((Float)ammoDmg.getMinimum()).floatValue();
        float max = ((Float)ammoDmg.getMaximum()).floatValue();
        switch (s) {
            case "from": {
                return MiscUtils.getNumberFormat((int)1, (boolean)true, (String)langCode).format(min / 2.0f);
            }
            case "to": {
                if (!(min < max - 0.01f)) break;
                return MiscUtils.getNumberFormat((int)1, (boolean)true, (String)langCode).format(max / 2.0f);
            }
            case "rounds_provided": {
                return MiscUtils.getNumberFormat((int)0, (boolean)true, (String)langCode).format(this.ammo[0].getAmmoCapacity());
            }
            case "item": {
                NonNullList items = NonNullList.func_191196_a();
                Arrays.stream(this.ammo).forEach(a -> {
                    String[] aSubtypes = a.getSubtypes();
                    ResourceLocation aId = a.getId();
                    if (aSubtypes != null && aSubtypes.length > 0) {
                        Arrays.stream(aSubtypes).forEach(as -> items.add((Object)AmmunitionRegistry.INSTANCE.getItem(aId, (String)as)));
                    } else {
                        items.add((Object)AmmunitionRegistry.INSTANCE.getItem(aId));
                    }
                });
                return ItemStackUtil.serializeIngredient((Ingredient)Ingredient.func_193369_a((ItemStack[])((ItemStack[])items.toArray((Object[])new ItemStack[0]))));
            }
        }
        return null;
    }
}

