/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.assembly.AssemblyIngredient;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

@SideOnly(value=Side.CLIENT)
public class ComponentAssemblyProcessor
implements IComponentProcessor {
    IAssemblyRecipe recipe;

    public void setup(IVariableProvider<String> provider) {
        this.recipe = AssemblyManager.INSTANCE.getRecipe(new ResourceLocation((String)provider.get("recipe")));
    }

    public String process(String s) {
        if (this.recipe != null) {
            String langCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            if (s.equals("output")) {
                return ItemStackUtil.serializeStack((ItemStack)this.recipe.getRecipeOutput());
            }
            if (s.startsWith("input_")) {
                try {
                    int i = Integer.parseInt(s.substring("input_".length()));
                    NonNullList<Ingredient> items = this.recipe.getIngredients();
                    if (i < items.size()) {
                        Ingredient ingredient = (Ingredient)items.get(i);
                        if (ingredient instanceof AssemblyIngredient) {
                            int cnt = ((AssemblyIngredient)ingredient).getCount();
                            ingredient = Ingredient.func_193369_a((ItemStack[])((ItemStack[])Arrays.stream(ingredient.func_193365_a()).map(stack -> ComponentAssemblyProcessor.copyStackWithSize(stack, cnt)).toArray(ItemStack[]::new)));
                        }
                        return ItemStackUtil.serializeIngredient((Ingredient)ingredient);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                if (s.equals("rf_cost")) {
                    return MiscUtils.getNumberSiPrefixed((double)(this.recipe.getFluxPerTick() * this.recipe.getProcessTime()), (int)1, (String)langCode);
                }
                if (s.equals("time_processing")) {
                    return MiscUtils.getTimeFromTicks((int)this.recipe.getProcessTime());
                }
                if (s.equals("rf_cost_full")) {
                    return MiscUtils.getNumberFormat((int)0, (boolean)true, (String)langCode).format((long)this.recipe.getFluxPerTick() * (long)this.recipe.getProcessTime());
                }
                if (s.equals("time_processing_full")) {
                    return MiscUtils.getNumberFormat((int)0, (boolean)true, (String)langCode).format(this.recipe.getProcessTime());
                }
            }
        }
        return null;
    }

    private static ItemStack copyStackWithSize(ItemStack stack, int size) {
        stack = stack.func_77946_l();
        stack.func_190920_e(size);
        return stack;
    }
}

