/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.book.gui.GuiBook;

@SideOnly(value=Side.CLIENT)
public class ComponentCustomText
implements ICustomComponent {
    int x;
    int y;
    @VariableHolder
    public String text;
    @VariableHolder
    @SerializedName(value="color")
    public String colorStr;
    @SerializedName(value="line_height")
    public int lineHeight = 9;
    public String alignment = "left";
    public float rotation = 0.0f;
    private transient boolean blockyFont;
    transient Integer color;
    private transient int tx = 0;
    transient boolean visible = true;

    public ComponentCustomText() {
    }

    public ComponentCustomText(String text, String color) {
        this.text = text;
        this.colorStr = color;
    }

    public void build(int x, int y, int pgNum) {
        this.x = x;
        this.y = y;
        try {
            this.color = Integer.parseInt(this.colorStr, 16);
        }
        catch (NumberFormatException var5) {
            this.color = null;
        }
    }

    public void render(IComponentRenderContext context, float partTicks, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        FontRenderer font = context.getFont();
        boolean wasUnicode = font.func_82883_a();
        font.func_78264_a(!this.blockyFont);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        font.func_175065_a(this.text, (float)this.tx, 0.0f, ((Integer)MiscUtils.defIfNull((Object)this.color, () -> ((IComponentRenderContext)context).getTextColor())).intValue(), false);
        GlStateManager.func_179121_F();
        font.func_78264_a(wasUnicode);
    }

    public void onDisplayed(IComponentRenderContext context) {
        GuiScreen gui = context.getGui();
        if (gui instanceof GuiBook) {
            GuiBook guiBook = (GuiBook)gui;
            FontRenderer font = context.getFont();
            boolean wasUnicode = font.func_82883_a();
            this.blockyFont = guiBook.book.useBlockyFont;
            if (!this.blockyFont) {
                font.func_78264_a(true);
            }
            this.tx = this.alignment.equals("right") ? -font.func_78256_a(this.text) : (this.alignment.equals("center") ? -(font.func_78256_a(this.text) / 2) : 0);
            font.func_78264_a(wasUnicode);
        }
    }
}

