/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import com.mojang.realmsclient.gui.ChatFormatting;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.electrolytegen.IElectrolyteRecipe;
import de.sanandrew.mods.turretmod.client.compat.patchouli.ComponentEntryList;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.book.gui.GuiBook;

public class ComponentElectrolytes
extends ComponentEntryList<ComponentItemRow> {
    @VariableHolder
    @SerializedName(value="ttip_efficiency")
    public String tTipTxtEfficiency;
    @VariableHolder
    @SerializedName(value="ttip_processing_time")
    public String tTipTxtProcTime;
    @VariableHolder
    @SerializedName(value="ttip_trash")
    public String tTipTxtTrash;
    @VariableHolder
    @SerializedName(value="ttip_treasure")
    public String tTipTxtTreasure;
    private static final int ENTRY_HEIGHT = 19;
    static final int MAX_ITEMS_PER_ROW = 6;

    @Override
    int getEntryHeight() {
        return 19;
    }

    @Override
    public void buildEntries(IComponentRenderContext context, GuiBook book, List<ComponentItemRow> entries, int x, int y) {
        ArrayList<IElectrolyteRecipe> recipes = new ArrayList<IElectrolyteRecipe>(ElectrolyteManager.INSTANCE.getFuels());
        recipes.sort((r1, r2) -> {
            int cmp = Float.compare(r1.getEfficiency(), r2.getEfficiency());
            if (cmp == 0) {
                cmp = Integer.compare(r1.getProcessTime(), r2.getProcessTime());
            }
            if (cmp == 0) {
                cmp = ((Ingredient)r1.getIngredients().get(0)).func_193365_a()[0].func_82833_r().compareTo(((Ingredient)r2.getIngredients().get(0)).func_193365_a()[0].func_82833_r());
            }
            return cmp;
        });
        int max = recipes.size();
        for (int i = 0; i < max; i += 6) {
            int id = i / 6;
            ComponentItemRow row = new ComponentItemRow(id, recipes.subList(i, Math.min(i + 6, max)));
            row.build(x + 2, y + 2 + id * 19, book.getPage());
            entries.add(row);
        }
    }

    @Override
    void setEntryScroll(ComponentItemRow entry, int prevShownPos, int currShownPos) {
        ComponentItemRow componentItemRow = entry;
        componentItemRow.y = componentItemRow.y + (prevShownPos - currShownPos) * 19;
        entry.visible = entry.id >= currShownPos && entry.id < currShownPos + this.maxEntriesShown;
    }

    @Override
    public void render(IComponentRenderContext context, float partTicks, int mouseX, int mouseY) {
        super.render(context, partTicks, mouseX, mouseY);
        this.entries.forEach(e -> e.render(context, partTicks, mouseX, mouseY));
    }

    final class ComponentItemRow
    implements ICustomComponent {
        private int x;
        private int y;
        private final int id;
        private final IElectrolyteRecipe[] recipes;
        private final String[][][] tooltips;
        private final ItemStack[][] ingredients;
        boolean visible = true;

        ComponentItemRow(int id, List<IElectrolyteRecipe> recipes) {
            this.id = id;
            this.recipes = recipes.toArray(new IElectrolyteRecipe[0]);
            this.tooltips = new String[this.recipes.length][][];
            this.ingredients = new ItemStack[this.recipes.length][];
        }

        public void build(int x, int y, int pgNum) {
            this.x = x;
            this.y = y;
            int max = this.recipes.length;
            for (int i = 0; i < max; ++i) {
                if (this.recipes[i] == null) continue;
                float efficiency = this.recipes[i].getEfficiency();
                int procTime = this.recipes[i].getProcessTime();
                float trash = this.recipes[i].getTrashChance();
                float treasure = this.recipes[i].getTreasureChance();
                this.ingredients[i] = ((Ingredient)this.recipes[i].getIngredients().get(0)).func_193365_a();
                this.tooltips[i] = new String[this.ingredients[i].length][];
                int maxIng = this.ingredients[i].length;
                for (int j = 0; j < maxIng; ++j) {
                    String[] ttip = new String[]{this.ingredients[i][j].func_82833_r(), ChatFormatting.GRAY + String.format(ComponentElectrolytes.this.tTipTxtEfficiency, Float.valueOf(efficiency * 100.0f)), ChatFormatting.GRAY + String.format(ComponentElectrolytes.this.tTipTxtProcTime, MiscUtils.getTimeFromTicks((int)procTime, (int)1)), ChatFormatting.GRAY + String.format(ComponentElectrolytes.this.tTipTxtTrash, Float.valueOf(trash * 100.0f)), ChatFormatting.GRAY + String.format(ComponentElectrolytes.this.tTipTxtTreasure, Float.valueOf(treasure * 100.0f))};
                    this.tooltips[i][j] = ttip;
                }
            }
        }

        public void render(IComponentRenderContext context, float v, int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            long currTime = System.currentTimeMillis() / 4250L;
            int max = this.recipes.length;
            for (int i = 0; i < max; ++i) {
                if (this.recipes[i] == null) continue;
                int ingId = (int)currTime % this.ingredients[i].length;
                this.renderItem(context, this.x + i * 19, this.y, mouseX, mouseY, this.ingredients[i][ingId], this.tooltips[i][ingId]);
            }
        }

        private void renderItem(IComponentRenderContext context, int x, int y, int mouseX, int mouseY, ItemStack stack, String[] ttip) {
            RenderItem itemRender = context.getGui().field_146297_k.func_175599_af();
            RenderHelper.func_74520_c();
            itemRender.func_180450_b(stack, x, y);
            itemRender.func_175030_a(context.getGui().field_146297_k.field_71466_p, stack, x, y);
            if (context.isAreaHovered(mouseX, mouseY, x, y, 16, 16)) {
                context.setHoverTooltip(Arrays.asList(ttip));
            }
        }
    }
}

