/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.client.compat.patchouli.PatchouliMouseEventHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;

@SideOnly(value=Side.CLIENT)
public abstract class ComponentEntryList<T>
implements ICustomComponent {
    private int x;
    private int y;
    public transient int pgNum;
    @VariableHolder
    @SerializedName(value="target_id")
    public String targetId;
    @SerializedName(value="max_entries_shown")
    public int maxEntriesShown = 5;
    @SerializedName(value="title_color")
    public String colorStr;
    @VariableHolder
    public String title;
    protected final transient List<T> entries = new ArrayList<T>();
    private transient Integer color;
    private transient GuiButtonBook prevScrollBtn;
    private transient GuiButtonBook nextScrollBtn;
    private transient int entriesShownPos = 0;

    public void build(int x, int y, int pgNum) {
        try {
            this.color = Integer.parseInt(this.colorStr, 16);
        }
        catch (NumberFormatException var5) {
            this.color = null;
        }
        this.x = x;
        this.y = y;
        this.pgNum = pgNum;
    }

    public abstract void buildEntries(IComponentRenderContext var1, GuiBook var2, List<T> var3, int var4, int var5);

    public void onDisplayed(IComponentRenderContext context) {
        GuiBook guiBook = ComponentEntryList.getGuiBook(context);
        if (guiBook == null) {
            return;
        }
        guiBook.getButtonList().remove(this.prevScrollBtn);
        guiBook.getButtonList().remove(this.nextScrollBtn);
        guiBook.getButtonList().removeIf(this.entries::contains);
        this.entries.clear();
        this.buildEntries(context, guiBook, this.entries, this.x, this.y + 11);
        this.entries.forEach(e -> this.setEntryScroll(e, 0, this.entriesShownPos));
        if (this.entries.size() > this.maxEntriesShown) {
            this.prevScrollBtn = new GuiButtonBook(guiBook, this.x, this.y + 20, 330, 9, 11, 5, () -> this.entriesShownPos > 0 && guiBook.getPage() == this.pgNum / 2, new String[0]);
            this.nextScrollBtn = new GuiButtonBook(guiBook, this.x + 116 - 11, this.y + 20, 330, 15, 11, 5, () -> this.entriesShownPos + this.maxEntriesShown < this.entries.size() && guiBook.getPage() == this.pgNum / 2, new String[0]);
            context.registerButton((GuiButton)this.prevScrollBtn, this.pgNum, () -> this.moveButtons(true));
            context.registerButton((GuiButton)this.nextScrollBtn, this.pgNum, () -> this.moveButtons(false));
        }
    }

    void moveButtons(boolean prev) {
        int prevPos = this.entriesShownPos;
        this.entriesShownPos += prev && this.entriesShownPos > 0 ? -1 : (!prev && this.entriesShownPos + this.maxEntriesShown < this.entries.size() ? 1 : 0);
        if (this.entriesShownPos != prevPos) {
            this.entries.forEach(e -> this.setEntryScroll(e, prevPos, this.entriesShownPos));
        }
    }

    abstract int getEntryHeight();

    abstract void setEntryScroll(T var1, int var2, int var3);

    public void render(IComponentRenderContext context, float partTicks, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        int xPos = this.x + 58 - context.getFont().func_78256_a(this.title) / 2;
        context.getFont().func_175065_a(this.title, (float)xPos, (float)this.y, ((Integer)MiscUtils.defIfNull((Object)this.color, () -> ((IComponentRenderContext)context).getHeaderColor())).intValue(), false);
        GlStateManager.func_179121_F();
        PatchouliMouseEventHandler.setCurrHoveredComponent(this, context.isAreaHovered(mouseX, mouseY, this.x, this.y + 11, 116, this.maxEntriesShown * this.getEntryHeight() - 1));
    }

    private static GuiBook getGuiBook(IComponentRenderContext context) {
        GuiScreen gui = context.getGui();
        if (gui instanceof GuiBook) {
            return (GuiBook)gui;
        }
        return null;
    }
}

