/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import com.google.gson.annotations.SerializedName;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgrade;
import de.sanandrew.mods.turretmod.client.compat.patchouli.ComponentEntryList;
import de.sanandrew.mods.turretmod.client.compat.patchouli.PatchouliHelper;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;

public class ComponentTurretEntries
extends ComponentEntryList<GuiButtonEntry> {
    private static final int ENTRY_HEIGHT = 11;
    @SerializedName(value="entries_type")
    public String entriesType;
    private transient EntryType type;

    @Override
    public int getEntryHeight() {
        return 11;
    }

    @Override
    public void build(int x, int y, int pgNum) {
        super.build(x, y, pgNum);
        this.type = EntryType.getTypeFromString(this.entriesType);
    }

    @Override
    public void buildEntries(IComponentRenderContext context, GuiBook book, List<GuiButtonEntry> entries, int x, int y) {
        List<BookEntry> bookEntries = this.type.grabEntries(book, this.targetId);
        int max = bookEntries.size();
        for (int i = 0; i < max; ++i) {
            BookEntry entry = bookEntries.get(i);
            GuiButtonEntryFixed button = new GuiButtonEntryFixed(book, x, y + 19 + i * 11, entry, i);
            context.registerButton((GuiButton)button, this.pgNum, () -> GuiBookEntry.displayOrBookmark((GuiBook)book, (BookEntry)entry));
            entries.add(button);
        }
    }

    @Override
    void setEntryScroll(GuiButtonEntry entry, int prevShownPos, int currShownPos) {
        entry.field_146129_i += (prevShownPos - currShownPos) * 11;
        entry.field_146125_m = entry.field_146127_k >= currShownPos && entry.field_146127_k < currShownPos + this.maxEntriesShown;
    }

    private static enum EntryType {
        AMMO((g, s) -> AmmunitionRegistry.INSTANCE.getObjects(EntryType.getTurret(s)).stream().map(a -> (Pair)g.book.contents.recipeMappings.get(PatchouliHelper.getWrapper(AmmunitionRegistry.INSTANCE, a))).filter(Objects::nonNull).map(Pair::getKey)),
        UPGRADES((g, s) -> UpgradeRegistry.INSTANCE.getObjects().stream().filter(u -> UpgradeRegistry.INSTANCE.isApplicable((IUpgrade)u, EntryType.getTurret(s))).map(u -> (Pair)g.book.contents.recipeMappings.get(PatchouliHelper.getWrapper(UpgradeRegistry.INSTANCE, u))).filter(Objects::nonNull).map(Pair::getKey)),
        UNKNOWN((g, s) -> Stream.empty());

        private final BiFunction<GuiBook, String, Stream<BookEntry>> grabEntriesFunc;
        public static final EntryType[] VALUES;

        private EntryType(BiFunction<GuiBook, String, Stream<BookEntry>> grabEntriesFunc) {
            this.grabEntriesFunc = grabEntriesFunc;
        }

        public List<BookEntry> grabEntries(GuiBook book, String id) {
            return this.grabEntriesFunc.apply(book, id).distinct().filter(e -> e != null && !e.shouldHide()).sorted().collect(Collectors.toList());
        }

        public static EntryType getTypeFromString(String type) {
            return Arrays.stream(VALUES).filter(e -> e.name().equalsIgnoreCase(type)).findFirst().orElse(UNKNOWN);
        }

        private static ITurret getTurret(String id) {
            return TurretRegistry.INSTANCE.getObject(new ResourceLocation(id));
        }

        static {
            VALUES = EntryType.values();
        }
    }

    private class GuiButtonEntryFixed
    extends GuiButtonEntry {
        private final GuiBook parent;

        private GuiButtonEntryFixed(GuiBook parent, int x, int y, BookEntry entry, int i) {
            super(parent, x, y, entry, i);
            this.parent = parent;
            this.field_146127_k = i;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m && this.parent.getPage() + 1 != MathHelper.func_76123_f((float)((float)ComponentTurretEntries.this.pgNum / 1.99f))) {
                this.field_146125_m = false;
            }
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        }
    }
}

