/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;

@SideOnly(value=Side.CLIENT)
public class ComponentTurretStatProcessor
implements IComponentProcessor {
    ITurret turret;

    public void setup(IVariableProvider<String> provider) {
        this.turret = TurretRegistry.INSTANCE.getObject(new ResourceLocation((String)provider.get("turret_type")));
    }

    public String process(String s) {
        String langCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        switch (s) {
            case "tier": {
                return MiscUtils.getNumberFormat((int)0, (boolean)false, (String)langCode).format(this.turret.getTier());
            }
            case "health": {
                return MiscUtils.getNumberFormat((int)1, (boolean)true, (String)langCode).format(this.turret.getHealth() / 2.0f);
            }
            case "ammo": {
                return MiscUtils.getNumberFormat((int)0, (boolean)true, (String)langCode).format(this.turret.getAmmoCapacity());
            }
            case "reload": {
                return MiscUtils.getTimeFromTicks((int)this.turret.getReloadTicks());
            }
        }
        if (s.contains("range")) {
            AxisAlignedBB aabb = this.turret.getRangeBB(null);
            NumberFormat nf = MiscUtils.getNumberFormat((int)0, (boolean)true, (String)langCode);
            switch (s) {
                case "rangeLX": {
                    return nf.format(aabb.field_72340_a * -1.0);
                }
                case "rangeLY": {
                    return nf.format(aabb.field_72338_b * -1.0);
                }
                case "rangeLZ": {
                    return nf.format(aabb.field_72339_c * -1.0);
                }
                case "rangeHX": {
                    return nf.format(aabb.field_72336_d);
                }
                case "rangeHY": {
                    return nf.format(aabb.field_72337_e);
                }
                case "rangeHZ": {
                    return nf.format(aabb.field_72334_f);
                }
            }
        }
        return null;
    }
}

