/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.compat.patchouli;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.util.ItemStackUtil;

public class PageCustomCrafting
extends PageWithText {
    public static final int X = 9;
    public static final int Y = 4;
    public static final int RECIPE_HEIGHT = 78;
    public String title;
    @SerializedName(value="pattern_1")
    public String[] pattern1;
    @SerializedName(value="pattern_2")
    public String[] pattern2 = null;
    @SerializedName(value="shaped_1")
    public boolean shaped1 = true;
    @SerializedName(value="shaped_2")
    public boolean shaped2 = true;
    @SerializedName(value="mappings_1")
    public JsonObject mappings1;
    @SerializedName(value="mappings_2")
    public JsonObject mappings2 = null;
    @SerializedName(value="output_1")
    public String recipeOutput1;
    @SerializedName(value="output_2")
    public String recipeOutput2 = null;
    private transient String title1;
    private transient String title2;
    private final transient NonNullList<Ingredient> recipe1 = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
    private final transient NonNullList<Ingredient> recipe2 = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
    private transient ItemStack output1 = ItemStack.field_190927_a;
    private transient ItemStack output2 = ItemStack.field_190927_a;

    public static void registerPage() {
        if (Loader.isModLoaded((String)"patchouli")) {
            ClientBookRegistry.INSTANCE.pageTypes.put("sapturretmod:custom_crafting", PageCustomCrafting.class);
        }
    }

    public void build(BookEntry entry, int pageNum) {
        this.output1 = PageCustomCrafting.loadPattern(this.recipeOutput1, this.pattern1, this.mappings1, this.recipe1);
        this.output2 = PageCustomCrafting.loadPattern(this.recipeOutput2, this.pattern2, this.mappings2, this.recipe2);
        boolean customTitle = !Strings.isNullOrEmpty((String)this.title);
        this.title1 = !customTitle ? this.output1.func_82833_r() : this.title;
        this.title2 = "";
        if (ItemStackUtils.isValid((ItemStack)this.output2)) {
            String string = this.title2 = !customTitle ? this.output2.func_82833_r() : "";
            if (this.title1.equals(this.title2)) {
                this.title2 = "";
            }
        }
    }

    private static ItemStack loadPattern(String outputId, String[] pattern, JsonObject mappings, NonNullList<Ingredient> recipe) {
        String pStr;
        String string = pStr = pattern != null ? String.join((CharSequence)"", pattern) : "";
        if (!Strings.isNullOrEmpty((String)pStr) && mappings != null && outputId != null) {
            ItemStack output = ItemStackUtil.loadStackFromString((String)outputId);
            if (!ItemStackUtils.isValid((ItemStack)output)) {
                return ItemStack.field_190927_a;
            }
            char[] p = pStr.toCharArray();
            int max = p.length;
            for (int i = 0; i < max; ++i) {
                if (p[i] == ' ') continue;
                String key = String.valueOf(p[i]);
                if (mappings.has(key)) {
                    recipe.set(i, (Object)ItemStackUtil.loadIngredientFromString((String)mappings.getAsJsonPrimitive(key).getAsString()));
                    continue;
                }
                TmrConstants.LOG.log(Level.WARN, String.format("Skipping ingredient '%s' in pattern, as it isn't contained in the mapping", Character.valueOf(p[i])));
            }
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public void render(int mouseX, int mouseY, float pticks) {
        if (ItemStackUtils.isValid((ItemStack)this.output1)) {
            PageCustomCrafting.drawRecipe((IComponentRenderContext)this.parent, this.title1, this.output1, this.recipe1, this.shaped1, 9, 4, mouseX, mouseY);
        }
        if (ItemStackUtils.isValid((ItemStack)this.output2)) {
            PageCustomCrafting.drawRecipe((IComponentRenderContext)this.parent, this.title2, this.output2, this.recipe2, this.shaped2, 9, 82 - (Strings.isNullOrEmpty((String)this.title2) ? 10 : 0), mouseX, mouseY);
        }
    }

    private static void drawRecipe(IComponentRenderContext context, String title, ItemStack output, NonNullList<Ingredient> recipe, boolean shaped, int recipeX, int recipeY, int mouseX, int mouseY) {
        int wrap;
        FontRenderer fr = context.getFont();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(context.getCraftingTexture());
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)(recipeX - 2), (int)(recipeY - 2), (float)0.0f, (float)0.0f, (int)100, (int)62, (float)128.0f, (float)128.0f);
        if (!shaped) {
            int iconX = recipeX + 62;
            wrap = recipeY + 2;
            Gui.func_146110_a((int)iconX, (int)wrap, (float)0.0f, (float)64.0f, (int)11, (int)11, (float)128.0f, (float)128.0f);
            if (context.isAreaHovered(mouseX, mouseY, iconX, wrap, 11, 11)) {
                context.setHoverTooltip(Collections.singletonList(LangUtils.translate((String)"patchouli.gui.lexicon.shapeless", (Object[])new Object[0])));
            }
        }
        fr.func_175065_a(title, 58.0f - (float)fr.func_78256_a(title) / 2.0f, (float)(recipeY - 10), context.getHeaderColor(), false);
        context.renderItemStack(recipeX + 79, recipeY + 22, mouseX, mouseY, output);
        wrap = 3;
        int max = recipe.size();
        for (int i = 0; i < max; ++i) {
            context.renderIngredient(recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, (Ingredient)recipe.get(i));
        }
    }

    public int getTextHeight() {
        return 4 + 78 * (ItemStackUtils.isValid((ItemStack)this.output2) ? 2 : 1) - (Strings.isNullOrEmpty((String)this.title2) ? 23 : 13);
    }
}

