/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.effect;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.client.effect.ParticleAssemblySpark;
import de.sanandrew.mods.turretmod.client.effect.ParticleCryoTrail;
import de.sanandrew.mods.turretmod.registry.EnumEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleExplosion;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class EffectHandler {
    private EffectHandler() {
    }

    public static void handle(EnumEffect effect, double x, double y, double z, Tuple data) {
        Minecraft mc = Minecraft.func_71410_x();
        switch (effect) {
            case ASSEMBLY_SPARK: {
                EffectHandler.spawnAssemblySpark(mc.field_71452_i, (World)mc.field_71441_e, x, y, z);
                break;
            }
            case SHOTGUN_SMOKE: {
                EffectHandler.spawnShotgunSmoke(mc.field_71452_i, (World)mc.field_71441_e, x, y, z, ((Float)data.getValue(0)).floatValue(), ((Float)data.getValue(1)).floatValue());
                break;
            }
            case CRYO_VAPOR: {
                EffectHandler.spawnCryoVapor(mc.field_71452_i, (World)mc.field_71441_e, x, y, z, (Double)data.getValue(0), (Double)data.getValue(1), (Double)data.getValue(2));
                break;
            }
            case MINIGUN_SMOKE: {
                EffectHandler.spawnMinigunSmoke(mc.field_71452_i, (World)mc.field_71441_e, x, y, z, ((Float)data.getValue(0)).floatValue(), ((Float)data.getValue(1)).floatValue(), (Boolean)data.getValue(2));
                break;
            }
            case LEVEL_UP: {
                EffectHandler.playLevelUpSFX((World)mc.field_71441_e, x, y, z);
                break;
            }
            case PROJECTILE_DEATH: {
                EffectHandler.spawnProjectileDeathSmoke(mc.field_71452_i, (World)mc.field_71441_e, x, y, z);
            }
        }
    }

    private static void playLevelUpSFX(World world, double x, double y, double z) {
        world.func_184134_a(x, y, z, SoundEvents.field_187802_ec, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
    }

    private static void spawnAssemblySpark(ParticleManager renderer, World world, double x, double y, double z) {
        renderer.func_78873_a((Particle)new ParticleAssemblySpark(world, x, y, z, 0.0, 0.0, 0.0));
    }

    private static void spawnShotgunSmoke(ParticleManager renderer, World world, double x, double y, double z, float yaw, float pitch) {
        float rotXZ = -yaw / 180.0f * (float)Math.PI;
        float rotY = -pitch / 180.0f * (float)Math.PI - 0.1f;
        double yShift = Math.sin(rotY) * (double)0.6f + 1.5;
        double xShift = Math.sin(rotXZ) * (double)0.6f * Math.cos(rotY);
        double zShift = Math.cos(rotXZ) * (double)0.6f * Math.cos(rotY);
        for (int i = 0; i < 8; ++i) {
            renderer.func_78873_a(new ParticleSmokeNormal.Factory().func_178902_a(0, world, x + xShift, y + yShift, z + zShift, xShift * (double)0.1f + MiscUtils.RNG.randomDouble() * 0.05 - 0.025, yShift * (double)0.1f + MiscUtils.RNG.randomDouble() * 0.05 - 0.025, zShift * (double)0.1f + MiscUtils.RNG.randomDouble() * 0.05 - 0.025, new int[0]));
        }
    }

    private static void spawnMinigunSmoke(ParticleManager renderer, World world, double x, double y, double z, float yaw, float pitch, boolean isLeft) {
        float shift = (isLeft ? 45.0f : -45.0f) / 180.0f * (float)Math.PI;
        float rotXZ = -yaw / 180.0f * (float)Math.PI;
        float rotY = -pitch / 180.0f * (float)Math.PI - 0.1f;
        double motionX = Math.sin(rotXZ) * (double)0.06f * Math.cos(rotY);
        double motionY = Math.sin(rotY) * (double)0.06f;
        double motionZ = Math.cos(rotXZ) * (double)0.06f * Math.cos(rotY);
        x += Math.sin(rotXZ + shift) * (double)0.7f * Math.cos(rotY);
        y += Math.sin(rotY) * (double)0.6f + 1.5;
        z += Math.cos(rotXZ + shift) * (double)0.7f * Math.cos(rotY);
        for (int i = 0; i < 8; ++i) {
            double xDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
            double yDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
            double zDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
            renderer.func_78873_a(new ParticleSmokeNormal.Factory().func_178902_a(0, world, x, y, z, motionX + xDist, motionY + yDist, motionZ + zDist, new int[0]));
        }
    }

    private static void spawnCryoVapor(ParticleManager renderer, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        int max = 10;
        for (int i = 0; i < max; ++i) {
            double diffMotionX = motionX / (double)max;
            double diffMotionY = motionY / (double)max;
            double diffMotionZ = motionZ / (double)max;
            double partMotionX = diffMotionX + MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
            double partMotionY = -MiscUtils.RNG.randomDouble() * 0.025;
            double partMotionZ = diffMotionZ + MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
            renderer.func_78873_a((Particle)new ParticleCryoTrail(world, x - diffMotionX * (double)i, y - diffMotionY * (double)i, z - diffMotionZ * (double)i, partMotionX, partMotionY, partMotionZ));
        }
    }

    private static void spawnProjectileDeathSmoke(ParticleManager renderer, World world, double x, double y, double z) {
        for (int i = 0; i < 20; ++i) {
            renderer.func_78873_a(new ParticleExplosion.Factory().func_178902_a(0, world, x + MiscUtils.RNG.randomDouble() * 2.0 - 1.0, y + MiscUtils.RNG.randomDouble(), z + MiscUtils.RNG.randomDouble() * 2.0 - 1.0, MiscUtils.RNG.randomGaussian() * 0.02, MiscUtils.RNG.randomGaussian() * 0.02, MiscUtils.RNG.randomGaussian() * 0.02, new int[0]));
        }
    }
}

