/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.client.render.ForcefieldCube;
import de.sanandrew.mods.turretmod.init.TmrConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderForcefieldHandler
implements ISelectiveResourceReloadListener {
    public static final RenderForcefieldHandler INSTANCE = new RenderForcefieldHandler();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<ForcefieldCube> fadeOutFields = new ArrayList<ForcefieldCube>();
    private final Map<Integer, Queue<IForcefieldProvider>> fieldProviders = new ConcurrentHashMap<Integer, Queue<IForcefieldProvider>>();
    private ShieldTexture[] textures;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderEntity = mc.func_175606_aa();
        if (renderEntity == null) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        double[] renderPos = RenderForcefieldHandler.getPartialPos(renderEntity, partialTicks);
        ArrayList<ForcefieldCube> cubes = new ArrayList<ForcefieldCube>();
        Iterator<Map.Entry<Integer, Queue<IForcefieldProvider>>> it = this.fieldProviders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Queue<IForcefieldProvider>> entry = it.next();
            Entity entity = mc.field_71441_e.func_73045_a(entry.getKey().intValue());
            if (entity == null || entry.getValue().size() < 1) {
                it.remove();
                continue;
            }
            Iterator itFF = entry.getValue().iterator();
            while (itFF.hasNext()) {
                IForcefieldProvider ffProvider = (IForcefieldProvider)itFF.next();
                ColorObj color = new ColorObj(ffProvider.getShieldColor());
                double[] entityPos = RenderForcefieldHandler.getPartialPos(entity, partialTicks);
                ForcefieldCube cube = new ForcefieldCube(new Vec3d(entityPos[0] - renderPos[0], entityPos[1] - renderPos[1], entityPos[2] - renderPos[2]), ffProvider.getShieldBoundingBox(), color, ffProvider.cullShieldFaces());
                cube.fullRendered = ffProvider.renderFull();
                if (entity.field_70128_L || !entity.func_70089_S() || !ffProvider.isShieldActive() || !mc.field_71441_e.field_72996_f.contains(entity)) {
                    if (ffProvider.hasSmoothFadeOut()) {
                        this.fadeOutFields.add(cube);
                    }
                    itFF.remove();
                    continue;
                }
                if (TmrConfig.Client.calcForcefieldIntf) {
                    for (ForcefieldCube intfCube : cubes) {
                        cube.interfere(intfCube, false);
                        intfCube.interfere(cube, true);
                    }
                }
                cubes.add(cube);
            }
        }
        Iterator<ForcefieldCube> fadeOutIt = this.fadeOutFields.iterator();
        while (fadeOutIt.hasNext()) {
            ForcefieldCube shield = fadeOutIt.next();
            if (shield.boxColor.alpha() <= 0) {
                fadeOutIt.remove();
                continue;
            }
            cubes.add(shield);
            shield.boxColor.setAlpha(shield.boxColor.alpha() - 3);
        }
        this.renderCubes(cubes, mc, partialTicks);
    }

    private static void renderCube(ForcefieldCube cube, Tessellator tess) {
        tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (!cube.cullFaces) {
            GlStateManager.func_179129_p();
        }
        cube.draw(tess);
        tess.func_78381_a();
        if (!cube.cullFaces) {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
    }

    public void renderCubes(List<ForcefieldCube> cubes, Minecraft mc, float partialTicks) {
        int worldTicks = (int)(mc.field_71441_e.func_82737_E() % Integer.MAX_VALUE);
        if (this.textures == null) {
            this.textures = RenderForcefieldHandler.getTextures(mc.func_110442_L());
        }
        Tessellator tess = Tessellator.func_178181_a();
        for (ShieldTexture tx : this.textures) {
            float transformTexAmount = (float)(worldTicks % 400) + partialTicks;
            float texTranslateX = transformTexAmount * tx.moveMultiplierX;
            float texTranslateY = transformTexAmount * tx.moveMultiplierY;
            mc.field_71446_o.func_110577_a(tx.getTexture());
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)texTranslateX, (float)texTranslateY, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            for (ForcefieldCube cube : cubes) {
                RenderForcefieldHandler.renderCube(cube, tess);
            }
            GlStateManager.func_179128_n((int)5890);
            GL11.glLoadIdentity();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    /*
     * Exception decompiling
     */
    public static ShieldTexture[] getTextures(IResourceManager resourceManager) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static double[] getPartialPos(Entity e, double partialTicks) {
        return new double[]{e.field_70142_S + (e.field_70165_t - e.field_70142_S) * partialTicks, e.field_70137_T + (e.field_70163_u - e.field_70137_T) * partialTicks, e.field_70136_U + (e.field_70161_v - e.field_70136_U) * partialTicks};
    }

    public void addForcefieldRenderer(Entity entity, IForcefieldProvider provider) {
        Queue fields = this.fieldProviders.computeIfAbsent(entity.func_145782_y(), key -> new ConcurrentLinkedQueue());
        if (fields.stream().noneMatch(prov -> prov.getClass().equals(provider.getClass()))) {
            fields.add(provider);
        }
    }

    public boolean hasForcefield(Entity entity, Class<? extends IForcefieldProvider> providerCls) {
        return this.fieldProviders.containsKey(entity.func_145782_y()) && this.fieldProviders.get(entity.func_145782_y()).stream().anyMatch(prov -> prov.getClass().equals(providerCls));
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            this.textures = null;
        }
    }

    public static final class ShieldTexture {
        public float moveMultiplierX;
        public float moveMultiplierY;
        String texture;
        private ResourceLocation textureRL;

        public ResourceLocation getTexture() {
            return this.textureRL == null ? (this.textureRL = new ResourceLocation(this.texture)) : this.textureRL;
        }
    }
}

