/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui;

import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ContainerName;
import de.sanandrew.mods.sanlib.lib.client.gui.element.DynamicText;
import de.sanandrew.mods.sanlib.lib.client.gui.element.RedstoneFluxBar;
import de.sanandrew.mods.sanlib.lib.util.LangUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.client.gui.element.ElectrolyteBar;
import de.sanandrew.mods.turretmod.client.util.GuiHelper;
import de.sanandrew.mods.turretmod.inventory.container.ContainerElectrolyteGenerator;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteProcess;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.logging.log4j.Level;

public class GuiElectrolyteGenerator
extends GuiContainer
implements IGui,
RedstoneFluxBar.IGuiEnergyContainer,
ContainerName.IContainerName,
ElectrolyteBar.IGuiElectrolyte,
DynamicText.IGuiDynamicText {
    private final TileEntityElectrolyteGenerator generator;
    private int currEnergy;
    private int maxEnergy;
    private float currEffective;
    private int generatedEnergy;
    private float currPartTicks;
    private GuiDefinition guiDef;

    public GuiElectrolyteGenerator(InventoryPlayer invPlayer, TileEntityElectrolyteGenerator tile) {
        super((Container)new ContainerElectrolyteGenerator((IInventory)invPlayer, tile));
        this.generator = tile;
        try {
            this.guiDef = GuiDefinition.getNewDefinition((ResourceLocation)Resources.GUI_STRUCT_ELECTROLYTE.resource);
            this.field_146999_f = this.guiDef.width;
            this.field_147000_g = this.guiDef.height;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, (Object)e);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiHelper.initGuiDef(this.guiDef, this);
        this.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        IEnergyStorage stg = (IEnergyStorage)this.generator.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (stg != null) {
            this.currEnergy = stg.getEnergyStored();
            this.maxEnergy = stg.getMaxEnergyStored();
        }
        this.currEffective = this.generator.efficiency;
        this.generatedEnergy = this.generator.getGeneratedFlux();
        this.guiDef.update((IGui)this);
    }

    protected void func_146976_a(float partTicks, int mouseX, int mouseY) {
        this.currPartTicks = partTicks;
        GuiHelper.drawGDBackground(this.guiDef, this, partTicks, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        this.guiDef.drawForeground((IGui)this, mouseX, mouseY, this.currPartTicks);
        RenderHelper.func_74520_c();
    }

    public int getEnergy() {
        return this.currEnergy;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public GuiScreen get() {
        return this;
    }

    public int getScreenPosX() {
        return this.field_147003_i;
    }

    public int getScreenPosY() {
        return this.field_147009_r;
    }

    public String getContainerName() {
        return this.generator.hasCustomName() ? this.generator.getName() : LangUtils.translate((String)this.generator.getName(), (Object[])new Object[0]);
    }

    public GuiDefinition getDefinition() {
        return this.guiDef;
    }

    @Override
    public int getProcess(int slot) {
        ElectrolyteProcess proc = this.generator.processes[slot];
        return proc == null ? 0 : proc.getProgress();
    }

    @Override
    public int getMaxProcess(int slot) {
        ElectrolyteProcess proc = this.generator.processes[slot];
        return proc == null ? 0 : proc.recipe.getProcessTime();
    }

    public String getText(String key, String originalText) {
        if ("efficiency".equalsIgnoreCase(key)) {
            return String.format("%.2f%%", Float.valueOf(this.currEffective / 9.0f * 100.0f));
        }
        if ("powergen".equalsIgnoreCase(key)) {
            return String.format("%d RF/t", this.generatedEnergy);
        }
        return null;
    }
}

