/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui;

import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Button;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTurretProvider;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.util.GuiHelper;
import de.sanandrew.mods.turretmod.network.PacketPlayerTurretAction;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.turret.forcefield.TurretForcefield;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class GuiTurretInfo
extends GuiScreen
implements IGui,
IGuiTurretProvider {
    private static final int ACTION_ACTIVATE = 1;
    private static final int ACTION_DEACTIVATE = 2;
    private static final int ACTION_RANGE_SHOW = 3;
    private static final int ACTION_RANGE_HIDE = 4;
    private final ITurretInst turretInst;
    private int posX;
    private int posY;
    private int xSize;
    private int ySize;
    private GuiDefinition guiDef;
    private GuiElementInst setActive;
    private GuiElementInst setDeactive;
    private GuiElementInst showRange;
    private GuiElementInst hideRange;

    public GuiTurretInfo(ITurretInst turretInst) {
        this.turretInst = turretInst;
        try {
            this.guiDef = GuiDefinition.getNewDefinition((ResourceLocation)(turretInst.getTurret() instanceof TurretForcefield ? Resources.GUI_STRUCT_TINFO_FORCEFIELD.resource : Resources.GUI_STRUCT_TINFO.resource));
            this.xSize = this.guiDef.width;
            this.ySize = this.guiDef.height;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, (Object)e);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiHelper.initGuiDef(this.guiDef, this);
        this.posX = (this.field_146294_l - this.xSize) / 2;
        this.posY = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.setActive = this.guiDef.getElementById("activate");
        this.setDeactive = this.guiDef.getElementById("deactivate");
        this.showRange = this.guiDef.getElementById("showRange");
        this.hideRange = this.guiDef.getElementById("hideRange");
        this.setActive.setVisible(false);
        this.hideRange.setVisible(false);
        if (!this.getTurretInst().hasPlayerPermission((EntityPlayer)this.field_146297_k.field_71439_g)) {
            ((Button)this.setActive.get(Button.class)).setEnabled(false);
            ((Button)this.setDeactive.get(Button.class)).setEnabled(false);
            ((Button)this.showRange.get(Button.class)).setEnabled(false);
            ((Button)this.hideRange.get(Button.class)).setEnabled(false);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.checkGuiClose();
        this.guiDef.update((IGui)this);
        this.setDeactive.setVisible(this.turretInst.isActive());
        this.setActive.setVisible(!this.setDeactive.isVisible());
        this.hideRange.setVisible(this.turretInst.showRange());
        this.showRange.setVisible(!this.hideRange.isVisible());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GuiHelper.drawGDBackground(this.guiDef, this, partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.posX, (float)this.posY, (float)0.0f);
        this.guiDef.drawForeground((IGui)this, mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.guiDef.mouseClicked((IGui)this, mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.guiDef.mouseClickMove((IGui)this, mouseX, mouseY, mouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.guiDef.mouseReleased((IGui)this, mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.guiDef.handleMouseInput((IGui)this);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (!this.guiDef.keyTyped((IGui)this, typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.guiDef.guiClosed((IGui)this);
    }

    public boolean func_73868_f() {
        return false;
    }

    public GuiScreen get() {
        return this;
    }

    public GuiDefinition getDefinition() {
        return this.guiDef;
    }

    public int getScreenPosX() {
        return this.posX;
    }

    public int getScreenPosY() {
        return this.posY;
    }

    public boolean performAction(IGuiElement element, int action) {
        switch (action) {
            case 3: {
                this.turretInst.setShowRange(true);
                this.turretInst.get().field_70158_ak = true;
                return true;
            }
            case 4: {
                this.turretInst.setShowRange(false);
                this.turretInst.get().field_70158_ak = false;
                return true;
            }
            case 1: {
                PacketRegistry.sendToServer((IMessage)new PacketPlayerTurretAction(this.turretInst, 0));
                return true;
            }
            case 2: {
                PacketRegistry.sendToServer((IMessage)new PacketPlayerTurretAction(this.turretInst, 2));
                return true;
            }
        }
        return false;
    }

    @Override
    public ITurretInst getTurretInst() {
        return this.turretInst;
    }

    private void checkGuiClose() {
        EntityLiving turretL = this.turretInst.get();
        if (turretL.field_70128_L || (double)turretL.func_70032_d((Entity)this.field_146297_k.field_71439_g) > 6.0) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

