/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.assembly;

import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Button;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ContainerName;
import de.sanandrew.mods.sanlib.lib.client.gui.element.RedstoneFluxBar;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.client.util.GuiHelper;
import de.sanandrew.mods.turretmod.inventory.container.ContainerTurretAssembly;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketAssemblyToggleAutomate;
import de.sanandrew.mods.turretmod.network.PacketInitAssemblyCrafting;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.registry.Resources;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class GuiTurretAssembly
extends GuiContainer
implements IGui,
RedstoneFluxBar.IGuiEnergyContainer,
ContainerName.IContainerName {
    public final TileEntityTurretAssembly assembly;
    private int currEnergy;
    private int maxEnergy;
    private float currPartTicks;
    private GuiDefinition guiDef;
    public IAssemblyRecipe hoveredRecipe;
    public int[] hoveredRecipeCoords;
    public int[] currRecipeCoords;
    public static String currGroup;
    private GuiElementInst cancelButton;
    private GuiElementInst automateButton;
    private GuiElementInst manualButton;
    private boolean shiftPressed;

    public GuiTurretAssembly(InventoryPlayer invPlayer, TileEntityTurretAssembly tile) {
        super((Container)new ContainerTurretAssembly((IInventory)invPlayer, tile));
        this.assembly = tile;
        try {
            this.guiDef = GuiDefinition.getNewDefinition((ResourceLocation)Resources.GUI_STRUCT_ASSEMBLY.resource);
            this.field_146999_f = this.guiDef.width;
            this.field_147000_g = this.guiDef.height;
        }
        catch (IOException e) {
            TmrConstants.LOG.log(Level.ERROR, (Object)e);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        GuiHelper.initGuiDef(this.guiDef, this);
        this.cancelButton = this.guiDef.getElementById("cancel-button");
        this.automateButton = this.guiDef.getElementById("automate-button");
        this.manualButton = this.guiDef.getElementById("manual-button");
        if (this.assembly.currRecipe != null) {
            currGroup = this.assembly.currRecipe.getGroup();
        }
        this.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.hoveredRecipe = null;
        this.hoveredRecipeCoords = null;
        this.currRecipeCoords = null;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        IEnergyStorage stg = (IEnergyStorage)this.assembly.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN);
        if (stg != null) {
            this.currEnergy = stg.getEnergyStored();
            this.maxEnergy = stg.getMaxEnergyStored();
        }
        if (this.assembly.currRecipe != null) {
            ((Button)this.cancelButton.get(Button.class)).setEnabled(true);
            ((Button)this.automateButton.get(Button.class)).setEnabled(false);
            ((Button)this.manualButton.get(Button.class)).setEnabled(false);
        } else {
            ((Button)this.cancelButton.get(Button.class)).setEnabled(false);
            ((Button)this.automateButton.get(Button.class)).setEnabled(!this.assembly.isAutomated());
            ((Button)this.manualButton.get(Button.class)).setEnabled(this.assembly.isAutomated());
        }
        this.automateButton.setVisible(ItemStackUtils.isItem((ItemStack)this.assembly.getInventory().func_70301_a(2), (Item)ItemRegistry.ASSEMBLY_UPG_AUTO));
        this.manualButton.setVisible(this.automateButton.isVisible());
        this.guiDef.update((IGui)this);
    }

    protected void func_146976_a(float partTicks, int mouseX, int mouseY) {
        this.currPartTicks = partTicks;
        GuiHelper.drawGDBackground(this.guiDef, this, partTicks, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        this.guiDef.drawForeground((IGui)this, mouseX, mouseY, this.currPartTicks);
        RenderHelper.func_74520_c();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.guiDef.handleMouseInput((IGui)this);
    }

    public int getEnergy() {
        return this.currEnergy;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public GuiScreen get() {
        return this;
    }

    public int getScreenPosX() {
        return this.field_147003_i;
    }

    public int getScreenPosY() {
        return this.field_147009_r;
    }

    public String getContainerName() {
        return "";
    }

    public GuiDefinition getDefinition() {
        return this.guiDef;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.guiDef.mouseClicked((IGui)this, mouseX, mouseY, mouseButton);
    }

    public boolean performAction(IGuiElement element, int action) {
        switch (action) {
            case -1: {
                if (this.hoveredRecipe == null) break;
                PacketRegistry.sendToServer((IMessage)new PacketInitAssemblyCrafting(this.assembly, this.hoveredRecipe.getId(), this.shiftPressed ? 16 : 1));
                return true;
            }
            case 0: {
                PacketRegistry.sendToServer((IMessage)new PacketInitAssemblyCrafting(this.assembly));
                return true;
            }
            case 1: {
                PacketRegistry.sendToServer((IMessage)new PacketAssemblyToggleAutomate(this.assembly));
                return true;
            }
            case 2: {
                this.switchGroup(-1);
                return true;
            }
            case 3: {
                this.switchGroup(1);
                return true;
            }
        }
        return false;
    }

    private void switchGroup(int direction) {
        if (this.assembly.currRecipe == null) {
            int currInd;
            ArrayList<String> g = new ArrayList<String>(Arrays.asList(AssemblyManager.INSTANCE.getGroups()));
            if (direction < 0) {
                Collections.reverse(g);
            }
            if ((currInd = g.indexOf(currGroup) + 1) == g.size()) {
                currInd = 0;
            }
            if (currInd < g.size()) {
                currGroup = (String)g.get(currInd);
            }
        }
    }

    public void func_146282_l() throws IOException {
        this.shiftPressed = false;
        super.func_146282_l();
    }

    protected void func_73869_a(char keyChar, int keyCode) throws IOException {
        this.shiftPressed = keyCode == this.field_146297_k.field_71474_y.field_74311_E.func_151463_i();
        super.func_73869_a(keyChar, keyCode);
    }

    public int getCraftingCount() {
        return this.assembly.currRecipe != null ? (this.assembly.isAutomated() ? Integer.MAX_VALUE : this.assembly.craftingAmount) : 0;
    }

    public int getRfPerTick(IAssemblyRecipe recipe) {
        return recipe != null ? MathHelper.func_76123_f((float)((float)recipe.getFluxPerTick() * (this.assembly.hasSpeedUpgrade() ? 4.4f : 1.0f))) : 0;
    }

    public int getProcessTime(IAssemblyRecipe recipe) {
        return recipe != null ? MathHelper.func_76141_d((float)((float)recipe.getProcessTime() / (this.assembly.hasSpeedUpgrade() ? 4.0f : 1.0f))) : 0;
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }
}

