/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.config;

import de.sanandrew.mods.turretmod.init.TmrConfig;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
class GuiConfigScreen
extends GuiConfig {
    GuiConfigScreen(GuiScreen parentScreen) {
        super(parentScreen, GuiConfigScreen.getCfgElements(), "sapturretmod", "configMain", false, false, "Turret Mod Configuration");
    }

    private static List<IConfigElement> getCfgElements() {
        return TmrConfig.getCategoriesForGUI().entrySet().stream().map(e -> new ConfigFileElement((String)e.getKey(), (ConfigCategory[])e.getValue())).collect(Collectors.toList());
    }

    private static final class ConfigFileElement
    implements IConfigElement {
        final IConfigElement[] children;
        final String name;

        ConfigFileElement(String name, ConfigCategory[] children) {
            this.children = (IConfigElement[])Arrays.stream(children).map(ConfigElement::new).toArray(IConfigElement[]::new);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.name;
        }

        public String getLanguageKey() {
            return this.name;
        }

        public List<IConfigElement> getChildElements() {
            return Arrays.asList(this.children);
        }

        public ConfigGuiType getType() {
            return ConfigGuiType.CONFIG_CATEGORY;
        }

        public boolean isDefault() {
            return true;
        }

        public boolean showInGui() {
            return true;
        }

        public boolean isProperty() {
            return false;
        }

        public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
            return null;
        }

        public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
            return null;
        }

        public String getComment() {
            return null;
        }

        public boolean isList() {
            return false;
        }

        public boolean isListLengthFixed() {
            return false;
        }

        public int getMaxListLength() {
            return -1;
        }

        public Object getDefault() {
            return null;
        }

        public Object[] getDefaults() {
            return null;
        }

        public void setToDefault() {
        }

        public boolean requiresWorldRestart() {
            return false;
        }

        public boolean requiresMcRestart() {
            return false;
        }

        public Object get() {
            return null;
        }

        public Object[] getList() {
            return null;
        }

        public void set(Object value) {
        }

        public void set(Object[] aVal) {
        }

        public String[] getValidValues() {
            return null;
        }

        public Object getMinValue() {
            return null;
        }

        public Object getMaxValue() {
            return null;
        }

        public Pattern getValidationPattern() {
            return null;
        }
    }
}

