/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element;

import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Tooltip;
import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTurretProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AmmoItemTooltip
extends Tooltip {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "info_ammo_ttip");
    private boolean visible = true;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{16, 16});
        super.bakeData(gui, data, inst);
    }

    public GuiElementInst getContent(IGui gui, JsonObject data) {
        return new GuiElementInst((IGuiElement)new AmmoTooltip()).initialize(gui);
    }

    public void update(IGui gui, JsonObject data) {
        ItemStack stack = ((IGuiTurretProvider)gui).getTurretInst().getTargetProcessor().getAmmoStack();
        ((AmmoTooltip)this.getChild("content").get(AmmoTooltip.class)).currStack = stack;
        this.visible = ItemStackUtils.isValid((ItemStack)stack);
        super.update(gui, data);
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        if (!this.visible) {
            return;
        }
        if (IGuiElement.isHovering((IGui)gui, (int)x, (int)y, (int)mouseX, (int)mouseY, (int)this.size[0], (int)this.size[1])) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiUtils.drawGradientRect((int)x, (int)y, (int)this.size[0], (int)this.size[1], (int)-2130706433, (int)-2130706433, (boolean)false);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }
        super.render(gui, partTicks, x, y, mouseX, mouseY, data);
    }

    public int getWidth() {
        return this.size[0];
    }

    public int getHeight() {
        return this.size[1];
    }

    private static final class AmmoTooltip
    implements IGuiElement {
        private final List<GuiElementInst> lines = new ArrayList<GuiElementInst>();
        private ItemStack currStack = ItemStack.field_190927_a;
        private ItemStack prevStack = ItemStack.field_190927_a;
        private int width;
        private int height;

        private AmmoTooltip() {
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        }

        public void update(IGui gui, JsonObject data) {
            if (!ItemStackUtils.areEqual((ItemStack)this.currStack, (ItemStack)this.prevStack)) {
                this.prevStack = this.currStack;
                this.lines.clear();
                this.width = 0;
                this.height = 0;
                List ttip = gui.get().func_191927_a(this.currStack);
                for (String line : ttip) {
                    GuiElementInst txtElem = new GuiElementInst(new int[]{0, this.height}, (IGuiElement)new Text()).initialize(gui);
                    JsonUtils.addJsonProperty((JsonObject)txtElem.data, (String)"color", (String)"0xFFFFFFFF");
                    JsonUtils.addJsonProperty((JsonObject)txtElem.data, (String)"text", (String)line);
                    JsonUtils.addJsonProperty((JsonObject)txtElem.data, (String)"shadow", (Boolean)true);
                    txtElem.get().bakeData(gui, txtElem.data, txtElem);
                    this.lines.add(txtElem);
                    this.height += txtElem.get().getHeight() + (this.height == 0 ? 2 : 0);
                }
                this.height -= 2 + (ttip.size() < 2 ? 2 : 0);
            }
        }

        public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
            for (GuiElementInst line : this.lines) {
                GuiDefinition.renderElement((IGui)gui, (int)(x + line.pos[0]), (int)(y + line.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)line);
                this.width = Math.max(this.width, line.get().getWidth());
            }
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

