/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ElectrolyteBar
extends Texture {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "electrolyte_bar");
    private int energyBarWidth;
    private int slot;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        if (!(gui instanceof IGuiElectrolyte)) {
            throw new RuntimeException("Cannot use electrolyte_bar on a GUI which doesn't implement IGuiElectrolyte");
        }
        this.slot = JsonUtils.getIntVal((JsonElement)data.get("slot"));
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{16, 3});
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"uv", (int[])new int[]{176, 59});
        super.bakeData(gui, data, inst);
    }

    public void update(IGui gui, JsonObject data) {
        IGuiElectrolyte gel = (IGuiElectrolyte)gui;
        double energyPerc = (double)gel.getProcess(this.slot) / (double)gel.getMaxProcess(this.slot);
        this.energyBarWidth = Math.max(0, Math.min(this.size[0], MathHelper.func_76143_f((double)((1.0 - energyPerc) * (double)this.size[0]))));
    }

    protected void drawRect(IGui gui) {
        Gui.func_146110_a((int)0, (int)0, (float)this.uv[0], (float)this.uv[1], (int)this.energyBarWidth, (int)this.size[1], (float)this.textureSize[0], (float)this.textureSize[1]);
    }

    public int getWidth() {
        return this.energyBarWidth;
    }

    public int getHeight() {
        return this.size[1];
    }

    public static interface IGuiElectrolyte {
        public int getProcess(int var1);

        public int getMaxProcess(int var1);
    }
}

