/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.assembly;

import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiTurretAssembly;
import de.sanandrew.mods.turretmod.inventory.AssemblyInventory;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class AssemblyGhostItems
extends Texture {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "assembly.ghost_items");
    public final List<SlotData> slotsRendered = new ArrayList<SlotData>();
    public final ItemStack upgIconAuto = new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_AUTO);
    public final ItemStack upgIconSpeed = new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_SPEED);
    public final ItemStack upgIconFilter = new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_FILTER);
    public final ItemStack upgIconRedstone = new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_REDSTONE);
    public final ItemStack cartridge = new ItemStack((Item)ItemRegistry.AMMO_CARTRIDGE);

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        JsonUtils.addJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{16, 16});
        JsonUtils.addJsonProperty((JsonObject)data, (String)"uv", (int[])new int[]{0, 0});
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"color", (String)"0xA0FFFFFF");
        super.bakeData(gui, data, inst);
    }

    public void update(IGui gui, JsonObject data) {
        super.update(gui, data);
        this.slotsRendered.clear();
        GuiTurretAssembly gta = (GuiTurretAssembly)gui;
        if (!gta.assembly.hasAutoUpgrade()) {
            this.slotsRendered.add(new SlotData(this.upgIconAuto, 14, 100));
        }
        if (!gta.assembly.hasSpeedUpgrade()) {
            this.slotsRendered.add(new SlotData(this.upgIconSpeed, 14, 118));
        }
        if (!ItemStackUtils.isValid((ItemStack)gta.assembly.getInventory().func_70301_a(1))) {
            this.slotsRendered.add(new SlotData(this.cartridge, 181, 10));
        }
        if (!gta.assembly.hasFilterUpgrade()) {
            this.slotsRendered.add(new SlotData(this.upgIconFilter, 202, 100));
        } else {
            NonNullList<ItemStack> filteredStacks = gta.assembly.getFilterStacks();
            for (int i = 0; i < filteredStacks.size(); ++i) {
                ItemStack filterStack = (ItemStack)filteredStacks.get(i);
                if (!ItemStackUtils.isValid((ItemStack)filterStack) || ItemStackUtils.isValid((ItemStack)gta.assembly.getInventory().func_70301_a(i + AssemblyInventory.RESOURCE_SLOT_FIRST))) continue;
                int x = i % 9;
                int y = i / 9;
                this.slotsRendered.add(new SlotData(filterStack.func_77946_l(), 36 + x * 18, 100 + y * 18));
            }
        }
        if (!gta.assembly.hasRedstoneUpgrade()) {
            this.slotsRendered.add(new SlotData(this.upgIconRedstone, 202, 118));
        }
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        for (SlotData item : this.slotsRendered) {
            RenderUtils.renderStackInGui((ItemStack)item.stack, (int)item.x, (int)item.y, (double)1.0);
            this.uv = new int[]{item.x, item.y};
            GlStateManager.func_179097_i();
            super.render(gui, partTicks, item.x, item.y, mouseX, mouseY, data);
            GlStateManager.func_179126_j();
        }
    }

    public static class SlotData {
        public final ItemStack stack;
        public final int x;
        public final int y;

        public SlotData(ItemStack stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

