/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiTurretAssembly;
import java.util.Locale;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

public class AssemblyProgressBar
extends Texture {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "assembly.progress");
    private GuiElementInst label;
    private int progressWidth;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        JsonObject lblElem = data.getAsJsonObject("label");
        if (lblElem != null) {
            this.label = new GuiElementInst(JsonUtils.getIntArray((JsonElement)lblElem.get("offset"), (int[])new int[]{0, 0}, (Range)Range.is((Comparable)Integer.valueOf(2))), (IGuiElement)new AssemblyProgressLabel(), lblElem).initialize(gui);
            this.label.alignment = new String[]{JsonUtils.getStringVal((JsonElement)lblElem.get("alignment"), (String)"center")};
            this.label.get().bakeData(gui, this.label.data, this.label);
        }
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{50, 5});
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"uv", (int[])new int[]{0, 222});
        super.bakeData(gui, data, inst);
    }

    public void update(IGui gui, JsonObject data) {
        GuiTurretAssembly gta = (GuiTurretAssembly)gui;
        double perc = (double)gta.assembly.getTicksCrafted() / (double)gta.assembly.getMaxTicksCrafted();
        this.progressWidth = Math.max(0, Math.min(this.size[0], (int)Math.round(perc * (double)this.size[0])));
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        super.render(gui, partTicks, x, y, mouseX, mouseY, data);
        if (this.label != null) {
            int lblX = x + this.label.pos[0];
            switch (this.label.getAlignmentH()) {
                case CENTER: {
                    lblX += this.size[0] / 2;
                    break;
                }
                case RIGHT: {
                    lblX += this.size[0];
                }
            }
            GuiDefinition.renderElement((IGui)gui, (int)lblX, (int)(y + this.label.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.label);
        }
    }

    protected void drawRect(IGui gui) {
        Gui.func_146110_a((int)0, (int)0, (float)this.uv[0], (float)this.uv[1], (int)this.progressWidth, (int)this.size[1], (float)this.textureSize[0], (float)this.textureSize[1]);
    }

    public int getWidth() {
        return this.progressWidth;
    }

    public static class AssemblyProgressLabel
    extends Text {
        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            if (!data.has("color")) {
                JsonObject colorObj = new JsonObject();
                colorObj.addProperty("default", "0xFF9999FF");
                colorObj.addProperty("stroke", "0xFF000000");
                data.add("color", (JsonElement)colorObj);
            }
            JsonUtils.addJsonProperty((JsonObject)data, (String)"shadow", (Boolean)false);
            JsonUtils.addJsonProperty((JsonObject)data, (String)"wrapWidth", (Number)0);
            super.bakeData(gui, data, inst);
        }

        public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
            this.setColor("stroke");
            super.render(gui, partTicks, x + 1, y, mouseX, mouseY, data);
            super.render(gui, partTicks, x - 1, y, mouseX, mouseY, data);
            super.render(gui, partTicks, x, y + 1, mouseX, mouseY, data);
            super.render(gui, partTicks, x, y - 1, mouseX, mouseY, data);
            this.setColor(null);
            super.render(gui, partTicks, x, y, mouseX, mouseY, data);
        }

        public String getBakedText(IGui gui, JsonObject data) {
            return "";
        }

        public String getDynamicText(IGui gui, String originalText) {
            int cnt = ((GuiTurretAssembly)gui).getCraftingCount();
            return cnt > 0 ? (cnt == Integer.MAX_VALUE ? "\u221e" : String.format(Locale.ROOT, "%dx", cnt)) : "";
        }
    }
}

