/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ElementParent;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Tooltip;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiTurretAssembly;
import de.sanandrew.mods.turretmod.client.gui.element.assembly.AssemblyRecipeLabel;
import de.sanandrew.mods.turretmod.client.gui.element.assembly.AssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

public class AssemblyRecipeArea
extends ElementParent<String> {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod:assembly.recipes");
    private int width;
    private int height;
    private GuiElementInst activeRecipeMarker;
    private GuiElementInst recipeTooltip;

    public void buildChildren(IGui gui, JsonObject data, Map<String, GuiElementInst> listToBuild) {
        JsonObject dataArea = data.getAsJsonObject("scrollArea");
        for (String grp : AssemblyManager.INSTANCE.getGroups()) {
            GuiElementInst grpInst = new GuiElementInst((IGuiElement)new AssemblyRecipes(grp), dataArea).initialize(gui);
            grpInst.setVisible(false);
            listToBuild.put(grp, grpInst);
            if (GuiTurretAssembly.currGroup != null) continue;
            GuiTurretAssembly.currGroup = grp;
        }
    }

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        JsonObject arm = data.getAsJsonObject("activeRecipeMarker");
        this.activeRecipeMarker = new GuiElementInst(JsonUtils.getIntArray((JsonElement)arm.get("offset"), (Range)Range.is((Comparable)Integer.valueOf(2))), (IGuiElement)new Texture(), arm).initialize(gui);
        this.activeRecipeMarker.get().bakeData(gui, this.activeRecipeMarker.data, this.activeRecipeMarker);
        this.recipeTooltip = new GuiElementInst((IGuiElement)new RecipeTooltip(), data.getAsJsonObject("recipeTooltip")).initialize(gui);
        this.recipeTooltip.get().bakeData(gui, this.recipeTooltip.data, this.recipeTooltip);
        super.bakeData(gui, data, inst);
    }

    public void update(IGui gui, JsonObject data) {
        if (GuiTurretAssembly.currGroup == null) {
            return;
        }
        GuiElementInst grpInst = this.getChild(GuiTurretAssembly.currGroup);
        AssemblyRecipes grpImpl = (AssemblyRecipes)grpInst.get(AssemblyRecipes.class);
        GuiTurretAssembly gta = (GuiTurretAssembly)gui;
        this.width = grpImpl.getWidth();
        this.height = grpImpl.getHeight();
        Arrays.stream(this.getChildren()).forEach(e -> e.setVisible(false));
        grpInst.setVisible(true);
        if (gta.hoveredRecipe != null && gta.hoveredRecipeCoords != null) {
            this.recipeTooltip.get().update(gui, this.recipeTooltip.data);
        }
        super.update(gui, data);
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        super.render(gui, partTicks, x, y, mouseX, mouseY, data);
        GuiTurretAssembly gta = (GuiTurretAssembly)gui;
        if (gta.currRecipeCoords != null) {
            GuiDefinition.renderElement((IGui)gui, (int)(this.activeRecipeMarker.pos[0] + gta.currRecipeCoords[0]), (int)(this.activeRecipeMarker.pos[1] + gta.currRecipeCoords[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.activeRecipeMarker);
        }
        if (gta.hoveredRecipe != null && gta.hoveredRecipeCoords != null) {
            GuiDefinition.renderElement((IGui)gui, (int)gta.hoveredRecipeCoords[0], (int)gta.hoveredRecipeCoords[1], (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.recipeTooltip);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static final class RecipeTooltip
    extends Tooltip {
        private RecipeTooltip() {
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            JsonUtils.addJsonProperty((JsonObject)data, (String)"size", (int[])new int[]{18, 18});
            super.bakeData(gui, data, inst);
        }

        public GuiElementInst getContent(IGui gui, JsonObject data) {
            return new GuiElementInst((IGuiElement)new AssemblyRecipeLabel(), data.getAsJsonObject("label")).initialize(gui);
        }
    }
}

