/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.assembly.AssemblyIngredient;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiTurretAssembly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class AssemblyRecipeLabel
implements IGuiElement {
    private IAssemblyRecipe prevRecipe;
    private GuiElementInst itemTooltip;
    private GuiElementInst timeIcon;
    private GuiElementInst rfIcon;
    private int borderColor;
    private int compactIngredientsColumns;
    private int currWidth;
    private int currHeight;
    private long currTicks;
    private final List<RenderElement> renderedIngredients = new ArrayList<RenderElement>();
    private final List<RenderElement> renderedData = new ArrayList<RenderElement>();

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.currTicks = 0L;
        this.borderColor = MiscUtils.hexToInt((String)JsonUtils.getStringVal((JsonElement)data.get("borderColor")));
        this.compactIngredientsColumns = JsonUtils.getIntVal((JsonElement)data.get("compactIngredientsColumns"), (int)6);
        this.itemTooltip = new GuiElementInst((IGuiElement)new ItemTooltipText(), data.getAsJsonObject("itemTooltipData")).initialize(gui);
        this.itemTooltip.element.bakeData(gui, this.itemTooltip.data, this.itemTooltip);
        this.timeIcon = new GuiElementInst((IGuiElement)new Texture(), data.getAsJsonObject("timeIconData")).initialize(gui);
        JsonUtils.addDefaultJsonProperty((JsonObject)this.timeIcon.data, (String)"size", (int[])new int[]{9, 9});
        JsonUtils.addDefaultJsonProperty((JsonObject)this.timeIcon.data, (String)"uv", (int[])new int[]{230, 94});
        this.timeIcon.element.bakeData(gui, this.timeIcon.data, this.timeIcon);
        this.rfIcon = new GuiElementInst((IGuiElement)new Texture(), data.getAsJsonObject("rfIconData")).initialize(gui);
        JsonUtils.addJsonProperty((JsonObject)this.rfIcon.data, (String)"size", (int[])new int[]{9, 9});
        JsonUtils.addJsonProperty((JsonObject)this.rfIcon.data, (String)"uv", (int[])new int[]{230, 103});
        this.rfIcon.element.bakeData(gui, this.rfIcon.data, this.rfIcon);
    }

    public void update(IGui gui, JsonObject data) {
        GuiTurretAssembly gta = (GuiTurretAssembly)gui;
        this.prevRecipe = gta.hoveredRecipe;
        int ticksCrafting = gta.getProcessTime(gta.hoveredRecipe);
        int rfPerTick = gta.getRfPerTick(gta.hoveredRecipe);
        boolean shiftPressed = gta.isShiftPressed();
        NonNullList<Ingredient> ingredients = gta.hoveredRecipe.getIngredients();
        int ingredientSize = ingredients.size();
        ItemStack[][] ingredientsVariants = new ItemStack[ingredientSize][];
        int[] ingredientCounts = new int[ingredientSize];
        for (int i = 0; i < ingredientSize; ++i) {
            AssemblyIngredient aIng = (AssemblyIngredient)((Object)ingredients.get(i));
            ingredientsVariants[i] = aIng.func_193365_a();
            ingredientCounts[i] = aIng.getCount();
        }
        this.itemTooltip.element.update(gui, this.itemTooltip.data);
        this.timeIcon.element.update(gui, this.timeIcon.data);
        this.rfIcon.element.update(gui, this.rfIcon.data);
        ++this.currTicks;
        this.renderedIngredients.clear();
        this.renderedData.clear();
        ItemTooltipText itt = (ItemTooltipText)this.itemTooltip.get(ItemTooltipText.class);
        int x = 0;
        int y = 0;
        this.currWidth = itt.getWidth();
        int bar1Y = y += itt.getHeight() + 2;
        y += 2;
        int col = 0;
        for (int i = 0; i < ingredientsVariants.length; ++i) {
            ItemStack[] variants = ingredientsVariants[i];
            ItemStack variant = variants[(int)(this.currTicks / 20L) % variants.length];
            if (shiftPressed) {
                this.renderedIngredients.add(new RenderElement(x + 1, ++y, (xr, yr, mx, my, pt) -> RenderUtils.renderStackInGui((ItemStack)variant, (int)xr, (int)yr, (double)0.5)));
                List ingLines = gui.get().func_191927_a(variant);
                ingLines.set(0, String.format("%dx %s", ingredientCounts[i], ingLines.get(0)));
                for (String line : ingLines) {
                    this.renderedIngredients.add(new RenderElement(x + 11, y, (xr, yr, mx, my, pt) -> itt.fontRenderer.func_175065_a(line, (float)xr, (float)yr, itt.color, itt.shadow)));
                    y += 10;
                    this.currWidth = Math.max(this.currWidth, 11 + itt.fontRenderer.func_78256_a(line));
                }
                continue;
            }
            int ingSize = ingredientCounts[i];
            this.renderedIngredients.add(new RenderElement(x + col * 18 + 1, y + 1, (xr, yr, mx, my, pt) -> RenderUtils.renderStackInGui((ItemStack)variant, (int)xr, (int)yr, (double)1.0, (FontRenderer)itt.fontRenderer, (String)String.format("%d", ingSize), (boolean)true)));
            this.currWidth = Math.max(this.currWidth, ++col * 18);
            if (col >= this.compactIngredientsColumns && i < ingredientsVariants.length - 1) {
                y += 18;
                col = 0;
                continue;
            }
            if (i != ingredientsVariants.length - 1) continue;
            y += 19;
        }
        this.renderedData.add(new RenderElement(x - 2, bar1Y, (xr, yr, mx, my, pt) -> Gui.func_73734_a((int)xr, (int)yr, (int)(xr + this.currWidth + 4), (int)(yr + 1), (int)this.borderColor)));
        this.renderedData.add(new RenderElement(x - 2, y, (xr, yr, mx, my, pt) -> Gui.func_73734_a((int)xr, (int)yr, (int)(xr + this.currWidth + 4), (int)(yr + 1), (int)this.borderColor)));
        String ticks = MiscUtils.getTimeFromTicks((int)ticksCrafting);
        this.renderedData.add(new RenderElement(x, y += 3, (xr, yr, mx, my, pt) -> {
            this.timeIcon.element.render(gui, pt, xr, yr, mx, my, this.timeIcon.data);
            itt.fontRenderer.func_175065_a(ticks, (float)(xr + this.timeIcon.element.getWidth() + 2), (float)(yr + 1), itt.color, itt.shadow);
        }));
        this.currWidth = Math.max(this.currWidth, this.timeIcon.element.getWidth() + 2 + itt.fontRenderer.func_78256_a(ticks));
        String rf = String.format("%d RF/t", rfPerTick);
        this.renderedData.add(new RenderElement(x, y += Math.max(this.timeIcon.element.getHeight() + 2, itt.fontRenderer.field_78288_b), (xr, yr, mx, my, pt) -> {
            this.rfIcon.element.render(gui, pt, xr, yr, mx, my, this.rfIcon.data);
            itt.fontRenderer.func_175065_a(rf, (float)(xr + this.rfIcon.element.getWidth() + 2), (float)(yr + 1), itt.color, itt.shadow);
        }));
        this.currWidth = Math.max(this.currWidth, this.rfIcon.element.getWidth() + 2 + itt.fontRenderer.func_78256_a(rf));
        this.currHeight = y += Math.max(this.rfIcon.element.getHeight(), itt.fontRenderer.field_78288_b);
        GlStateManager.func_179126_j();
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        GuiDefinition.renderElement((IGui)gui, (int)x, (int)y, (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.itemTooltip);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        this.renderedIngredients.forEach(ri -> ri.render.accept(x + ri.x, y + ri.y, mouseX, mouseY, partTicks));
        GlStateManager.func_179121_F();
        GlStateManager.func_179097_i();
        this.renderedData.forEach(ri -> ri.render.accept(x + ri.x, y + ri.y, mouseX, mouseY, partTicks));
        GlStateManager.func_179126_j();
    }

    public boolean forceRenderUpdate(IGui gui) {
        return this.prevRecipe != ((GuiTurretAssembly)gui).hoveredRecipe;
    }

    public int getWidth() {
        return this.currWidth;
    }

    public int getHeight() {
        return this.currHeight;
    }

    @FunctionalInterface
    private static interface RenderFunction {
        public void accept(int var1, int var2, int var3, int var4, float var5);
    }

    public static class ItemTooltipText
    extends Text {
        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"color", (String)"0xFFFFFFFF");
            JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"shadow", (Boolean)true);
            super.bakeData(gui, data, inst);
        }

        public String getBakedText(IGui gui, JsonObject data) {
            return "";
        }

        public String getDynamicText(IGui gui, String originalText) {
            GuiTurretAssembly gta = (GuiTurretAssembly)gui;
            return gta.hoveredRecipe != null ? String.join((CharSequence)"\n", gui.get().func_191927_a(gta.hoveredRecipe.getRecipeOutput())) : "";
        }

        public boolean forceRenderUpdate(IGui gui) {
            return false;
        }
    }

    public static class RenderElement {
        public int x;
        public int y;
        public RenderFunction render;

        private RenderElement(int x, int y, RenderFunction render) {
            this.x = x;
            this.y = y;
            this.render = render;
        }
    }
}

