/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.assembly;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ScrollArea;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.api.assembly.IAssemblyRecipe;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiTurretAssembly;
import de.sanandrew.mods.turretmod.client.util.ResourceOrderer;
import de.sanandrew.mods.turretmod.registry.assembly.AssemblyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

class AssemblyRecipes
extends ScrollArea {
    private final String group;
    private ResourceLocation areaTexture;
    private int[] areaTextureUV;
    private int[] areaTextureSize;
    private int columns;

    AssemblyRecipes(String group) {
        this.group = group;
    }

    public GuiElementInst[] getElements(IGui gui, JsonObject elementData) {
        List recipes = AssemblyManager.INSTANCE.getRecipes(this.group).stream().sorted((r1, r2) -> ResourceOrderer.getComparator().compare(r1.getRecipeOutput(), r2.getRecipeOutput())).collect(Collectors.toList());
        HashMap<Integer, List> rowMap = new HashMap<Integer, List>();
        ArrayList<GuiElementInst> newRows = new ArrayList<GuiElementInst>();
        int max = recipes.size() - 1;
        for (int cellId = 0; cellId <= max; ++cellId) {
            int rowId = cellId / this.columns;
            int colId = cellId % this.columns + 1;
            List rowRecipes = rowMap.computeIfAbsent(rowId, k -> new ArrayList());
            rowRecipes.add(recipes.get(cellId));
            if (colId != this.columns && cellId != max) continue;
            GuiElementInst rowInst = new GuiElementInst();
            rowInst.pos = new int[]{0, rowId * 18};
            rowInst.element = new Row(rowRecipes.toArray(new IAssemblyRecipe[0]));
            newRows.add(rowInst);
        }
        return newRows.toArray(new GuiElementInst[0]);
    }

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.areaTexture = gui.getDefinition().getTexture(data.get("areaTexture"));
        this.areaTextureUV = JsonUtils.getIntArray((JsonElement)data.get("areaTextureUV"), (Range)Range.is((Comparable)Integer.valueOf(2)));
        this.areaTextureSize = JsonUtils.getIntArray((JsonElement)data.get("areaTextureSize"), (int[])new int[]{256, 256}, (Range)Range.is((Comparable)Integer.valueOf(2)));
        this.columns = JsonUtils.getIntVal((JsonElement)data.get("itemColumns"), (int)6);
        int rowCount = JsonUtils.getIntVal((JsonElement)data.get("itemRows"), (int)4);
        JsonUtils.addJsonProperty((JsonObject)data, (String)"areaSize", (int[])new int[]{this.columns * 18, rowCount * 18});
        JsonUtils.addJsonProperty((JsonObject)data, (String)"rasterized", (Boolean)true);
        super.bakeData(gui, data, inst);
    }

    private final class Row
    implements IGuiElement {
        private IAssemblyRecipe[] recipes;
        private boolean isHoveredOver;

        private Row(IAssemblyRecipe[] recipes) {
            this.recipes = recipes;
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        }

        public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
            this.isHoveredOver = false;
            GuiTurretAssembly gta = (GuiTurretAssembly)gui;
            IAssemblyRecipe currRecipe = gta.assembly.currRecipe;
            int localMouseX = mouseX - gui.getScreenPosX();
            int localMouseY = mouseY - gui.getScreenPosY();
            for (int i = 0; i < this.recipes.length; ++i) {
                int slotX = x + i * 18;
                RenderUtils.renderStackInGui((ItemStack)this.recipes[i].getRecipeOutput(), (int)(slotX + 1), (int)(y + 1), (double)1.0, (FontRenderer)gui.get().field_146297_k.field_71466_p);
                if (currRecipe != null) {
                    if (this.recipes[i].getId().equals((Object)currRecipe.getId())) {
                        gta.currRecipeCoords = new int[]{slotX, y};
                    } else {
                        this.renderDisabledSlot(gta.field_146297_k, slotX, y);
                    }
                }
                if (localMouseX < slotX || localMouseX >= slotX + 18 || localMouseY < y || localMouseY >= y + 18 || currRecipe != null && !this.recipes[i].getId().equals((Object)currRecipe.getId())) continue;
                this.isHoveredOver = true;
                this.renderHoveredSlot(slotX, y);
                gta.hoveredRecipe = this.recipes[i];
                gta.hoveredRecipeCoords = new int[]{slotX, y};
            }
        }

        private void renderDisabledSlot(Minecraft mc, int x, int y) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            mc.field_71446_o.func_110577_a(AssemblyRecipes.this.areaTexture);
            Gui.func_146110_a((int)(x + 1), (int)(y + 1), (float)(AssemblyRecipes.this.areaTextureUV[0] + x + 1), (float)(AssemblyRecipes.this.areaTextureUV[1] + y + 1), (int)16, (int)16, (float)AssemblyRecipes.this.areaTextureSize[0], (float)AssemblyRecipes.this.areaTextureSize[1]);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }

        private void renderHoveredSlot(int x, int y) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 17), (int)(y + 17), (int)-2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179126_j();
        }

        public boolean mouseClicked(IGui gui, int mouseX, int mouseY, int mouseButton) {
            return this.isHoveredOver && mouseButton == 0 && gui.performAction((IGuiElement)this, -1);
        }

        public int getWidth() {
            return this.recipes.length * 18;
        }

        public int getHeight() {
            return 18;
        }
    }
}

