/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Tooltip;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

public class RemoteAccessHealth
implements IGuiElement {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "tcu.remote_access_health");
    private GuiElementInst pgTexture;
    private GuiElementInst tooltip;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.pgTexture = new GuiElementInst((IGuiElement)new HealthTexture(), data.getAsJsonObject("heartTexture")).initialize(gui);
        this.pgTexture.pos = JsonUtils.getIntArray((JsonElement)this.pgTexture.data.get("offset"), (Range)Range.is((Comparable)Integer.valueOf(2)));
        this.pgTexture.get().bakeData(gui, this.pgTexture.data, this.pgTexture);
        JsonObject ttipData = data.getAsJsonObject("tooltip");
        JsonUtils.addJsonProperty((JsonObject)ttipData, (String)"size", (int[])new int[]{16, 16});
        this.tooltip = new GuiElementInst((IGuiElement)new HealthTooltip(), ttipData).initialize(gui);
        this.tooltip.get().bakeData(gui, this.tooltip.data, this.tooltip);
    }

    public void update(IGui gui, JsonObject data) {
        this.pgTexture.get().update(gui, this.pgTexture.data);
        this.tooltip.get().update(gui, this.pgTexture.data);
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        this.pgTexture.get().render(gui, partTicks, x + this.pgTexture.pos[0], y + this.pgTexture.pos[1], mouseX, mouseY, this.pgTexture.data);
        int locMouseX = mouseX - gui.getScreenPosX();
        int locMouseY = mouseY - gui.getScreenPosY();
        if (x <= locMouseX && locMouseX < x + 16 && y <= locMouseY && locMouseY < y + 16) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-2130706433);
        }
        this.tooltip.get().render(gui, partTicks, x + this.tooltip.pos[0], y + this.tooltip.pos[1], mouseX, mouseY, this.tooltip.data);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    private static final class HealthTexture
    extends Texture {
        private int progressHeight;

        private HealthTexture() {
        }

        public void update(IGui gui, JsonObject data) {
            super.update(gui, data);
            EntityLiving turretL = ((IGuiTcuInst)gui).getTurretInst().get();
            float perc = 1.0f - turretL.func_110143_aJ() / turretL.func_110138_aP();
            this.progressHeight = Math.max(0, Math.min(this.size[1], Math.round(perc * (float)this.size[1])));
        }

        protected void drawRect(IGui gui) {
            Gui.func_146110_a((int)0, (int)this.progressHeight, (float)this.uv[0], (float)(this.uv[1] + this.progressHeight), (int)this.size[0], (int)(this.size[1] - this.progressHeight), (float)this.textureSize[0], (float)this.textureSize[1]);
        }

        public int getHeight() {
            return this.size[1] - this.progressHeight;
        }
    }

    private static final class HealthText
    extends Text {
        private String health;
        private String maxHealth;

        private HealthText() {
        }

        public String getDynamicText(IGui gui, String originalText) {
            return String.format(originalText, this.health, this.maxHealth);
        }

        public void update(IGui gui, JsonObject data) {
            super.update(gui, data);
            EntityLiving turretL = ((IGuiTcuInst)gui).getTurretInst().get();
            this.health = TmrUtils.DECIMAL_FORMAT.format(turretL.func_110143_aJ() / 2.0f);
            this.maxHealth = TmrUtils.DECIMAL_FORMAT.format(turretL.func_110138_aP() / 2.0f);
        }
    }

    private static final class HealthTooltip
    extends Tooltip {
        private HealthTooltip() {
        }

        public GuiElementInst getContent(IGui gui, JsonObject data) {
            JsonObject cntData = new JsonObject();
            JsonUtils.addJsonProperty((JsonObject)cntData, (String)"text", (String)JsonUtils.getStringVal((JsonElement)data.get("text")));
            JsonUtils.addJsonProperty((JsonObject)cntData, (String)"color", (String)JsonUtils.getStringVal((JsonElement)data.get("textColor"), (String)"0xFFFFFFFF"));
            return new GuiElementInst((IGuiElement)new HealthText(), cntData).initialize(gui);
        }
    }
}

