/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu.info;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Tooltip;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class ErrorTooltip
extends Tooltip {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "tcu.info_error");
    private long errTimeActivated;
    private int errTimeDurationMS;
    private boolean shown;

    public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
        this.errTimeDurationMS = JsonUtils.getIntVal((JsonElement)data.get("timeShown"), (int)5000);
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"backgroundColor", (String)"0xF0100000");
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"borderTopColor", (String)"0x50FF0000");
        JsonUtils.addDefaultJsonProperty((JsonObject)data, (String)"borderBottomColor", (String)"0x507F0000");
        super.bakeData(gui, data, inst);
    }

    public GuiElementInst getContent(IGui gui, JsonObject data) {
        if (!data.has("content")) {
            GuiElementInst txtInst = new GuiElementInst((IGuiElement)new Text()).initialize(gui);
            JsonUtils.addJsonProperty((JsonObject)txtInst.data, (String)"text", (String)JsonUtils.getStringVal((JsonElement)data.get("text")));
            JsonUtils.addJsonProperty((JsonObject)txtInst.data, (String)"color", (String)JsonUtils.getStringVal((JsonElement)data.get("color"), (String)"0xFFFF8080"));
            JsonUtils.addJsonProperty((JsonObject)txtInst.data, (String)"wrapWidth", (Number)JsonUtils.getIntVal((JsonElement)data.get("wrapWidth"), (int)gui.getDefinition().width));
            return txtInst;
        }
        return super.getContent(gui, data);
    }

    public void activate() {
        this.errTimeActivated = System.currentTimeMillis();
        this.shown = true;
    }

    public void deactivate() {
        this.errTimeActivated = System.currentTimeMillis() - (long)this.errTimeDurationMS;
        this.shown = false;
    }

    public void update(IGui gui, JsonObject data) {
        super.update(gui, data);
        this.shown = this.errTimeActivated >= System.currentTimeMillis() - (long)this.errTimeDurationMS;
    }

    public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
        super.render(gui, partTicks, x, y + 24, mouseX, mouseY + 24, data);
    }

    public boolean isVisible() {
        return this.shown;
    }
}

