/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.element.tcu.level;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiDefinition;
import de.sanandrew.mods.sanlib.lib.client.gui.GuiElementInst;
import de.sanandrew.mods.sanlib.lib.client.gui.IGui;
import de.sanandrew.mods.sanlib.lib.client.gui.IGuiElement;
import de.sanandrew.mods.sanlib.lib.client.gui.element.ScrollArea;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Text;
import de.sanandrew.mods.sanlib.lib.client.gui.element.Texture;
import de.sanandrew.mods.sanlib.lib.util.JsonUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.LevelStorage;
import de.sanandrew.mods.turretmod.registry.upgrades.leveling.Stage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Range;

public class LevelModifiers
extends ScrollArea {
    public static final ResourceLocation ID = new ResourceLocation("sapturretmod", "tcu.levels_modifiers");
    public static final DecimalFormat FORMATTER = new DecimalFormat("+0.0;-0.0");
    private int prevModifierHash = 0;
    private Map<String, Stage.ModifierInfo> modifiers = Collections.emptyMap();

    public void setModifierList(IGui gui, JsonObject data, LevelStorage storage, ITurretInst turretInst) {
        this.modifiers = storage.fetchCurrentModifiers(turretInst);
        int currModifierHash = this.modifiers.hashCode();
        if (this.prevModifierHash != currModifierHash) {
            this.rebuildElements(gui, data);
            this.prevModifierHash = currModifierHash;
        }
    }

    public GuiElementInst[] getElements(IGui gui, JsonObject elementData) {
        ArrayList<GuiElementInst> elements = new ArrayList<GuiElementInst>();
        int posY = 0;
        for (Map.Entry<String, Stage.ModifierInfo> e : this.modifiers.entrySet()) {
            JsonObject elemData = JsonUtils.deepCopy((JsonObject)elementData.getAsJsonObject("node"));
            Stage.ModifierInfo info = e.getValue();
            GuiElementInst elem = new GuiElementInst(new int[]{0, posY}, (IGuiElement)new ModifierNode(e.getKey(), (info.getModValue() - info.baseValue) / info.baseValue * 100.0), elemData).initialize(gui);
            elem.get().bakeData(gui, elemData, elem);
            elements.add(elem);
            posY += elem.get().getHeight() + 1;
        }
        return elements.toArray(new GuiElementInst[0]);
    }

    public boolean bakeElements() {
        return false;
    }

    private static final class ModifierNode
    implements IGuiElement {
        private final String attributeName;
        private final double modifierValue;
        private GuiElementInst attrName;
        private GuiElementInst modValue;
        private GuiElementInst background;

        private ModifierNode(String attributeName, double modifierValue) {
            this.attributeName = attributeName;
            this.modifierValue = modifierValue;
        }

        public void bakeData(IGui gui, JsonObject data, GuiElementInst inst) {
            JsonObject jsonBackg = (JsonObject)MiscUtils.defIfNull((Object)data.getAsJsonObject("background"), JsonObject::new);
            this.background = new GuiElementInst((IGuiElement)new Texture(), jsonBackg).initialize(gui);
            this.background.get().bakeData(gui, jsonBackg, this.background);
            JsonObject jsonAttrName = (JsonObject)MiscUtils.defIfNull((Object)data.getAsJsonObject("attributeName"), JsonObject::new);
            JsonUtils.addJsonProperty((JsonObject)jsonAttrName, (String)"text", (String)("attribute." + this.attributeName));
            this.attrName = new GuiElementInst(JsonUtils.getIntArray((JsonElement)jsonAttrName.get("offset"), (int[])new int[]{5, 5}, (Range)Range.is((Comparable)Integer.valueOf(2))), (IGuiElement)new Text(), jsonAttrName).initialize(gui);
            this.attrName.get().bakeData(gui, jsonAttrName, this.attrName);
            JsonObject jsonModValue = (JsonObject)MiscUtils.defIfNull((Object)data.getAsJsonObject("modifierValue"), JsonObject::new);
            this.modValue = new GuiElementInst(JsonUtils.getIntArray((JsonElement)jsonModValue.get("offset"), (int[])new int[]{this.background.get().getWidth() - 5, 5}, (Range)Range.is((Comparable)Integer.valueOf(2))), (IGuiElement)new ModifierValueText(), jsonModValue).initialize(gui);
            this.modValue.alignment = new String[]{GuiElementInst.Justify.RIGHT.name(), GuiElementInst.Justify.TOP.name()};
            this.modValue.get().bakeData(gui, jsonModValue, this.modValue);
        }

        public void update(IGui gui, JsonObject data) {
            this.background.get().update(gui, this.background.data);
            this.attrName.get().update(gui, this.attrName.data);
            this.modValue.get().update(gui, this.modValue.data);
        }

        public void render(IGui gui, float partTicks, int x, int y, int mouseX, int mouseY, JsonObject data) {
            GuiDefinition.renderElement((IGui)gui, (int)x, (int)y, (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.background);
            GuiDefinition.renderElement((IGui)gui, (int)(x + this.attrName.pos[0]), (int)(y + this.attrName.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.attrName);
            GuiDefinition.renderElement((IGui)gui, (int)(x + this.modValue.pos[0]), (int)(y + this.modValue.pos[1]), (int)mouseX, (int)mouseY, (float)partTicks, (GuiElementInst)this.modValue);
        }

        public int getWidth() {
            return this.background.get().getWidth();
        }

        public int getHeight() {
            return this.background.get().getHeight();
        }

        private final class ModifierValueText
        extends Text {
            private ModifierValueText() {
            }

            public String getDynamicText(IGui gui, String originalText) {
                return String.format(originalText, FORMATTER.format(ModifierNode.this.modifierValue));
            }
        }
    }
}

